/*=========================================================================
 *=========================================================================
  == [DISCLAIMER]: THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS   ==
  == RELEASED "AS IS".  THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY     ==
  == KIND, EXPRESS OR IMPLIED, CONCERNING THIS SOFTWARE AND ANY          ==
  == ACCOMPANYING DOCUMENTATION, INCLUDING, WITHOUT LIMITATION, ANY      ==
  == WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  ==
  == IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR ANY DAMAGES      ==
  == ARISING OUT OF THE USE, OR INABILITY TO USE, THIS SOFTWARE OR ANY   ==
  == ACCOMPANYING DOCUMENTATION, EVEN IF INFORMED IN ADVANCE OF THE      ==
  == POSSIBLITY OF SUCH DAMAGES.                                         ==
  =========================================================================
  =========================================================================*/

/********************************************************************
 *                                                                  *
 *                         Routine:  adts.h                         *
 *                          Author:  J. Querns, Veridian Inc (Veda) *
 *                            Date:  24 Oct 95                      *
 *                                                                  *
 *  Description:  Include file for ADTS-related programs..          *
 *                                                                  *
 ********************************************************************/


/* Allocate & Define COMPLEX Number Structure */
struct COMPLEXN {
   float re;
   float im;
};

/* Allocate & Define ADTS Pixel structure */
struct ADTSPIX {
   char e;
   char i;
   char q;
};

/* Allocate & Define ADTS Image Offset Structure */
struct ADTSImgOff {
   long img;
   long hdr1;
   long hdr2;
   long hdr2len;
   long nsamps;
   long nlines;
};

/* Allocate & Define ADTS  Polarization Sub-image Offset Structures */  
struct ADTSImgOff  hhOff;            /* HH sub-image offset structure..*/
struct ADTSImgOff  hvOff;            /* HV sub-image offset structure..*/
struct ADTSImgOff  vhOff;            /* VH sub-image offset structure..*/
struct ADTSImgOff  vvOff;            /* VV sub-image offset structure..*/
