/*=========================================================================
 *=========================================================================
 == [DISCLAIMER]: THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS   ==
 == RELEASED "AS IS".  THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY     ==
 == KIND, EXPRESS OR IMPLIED, CONCERNING THIS SOFTWARE AND ANY          ==
 == ACCOMPANYING DOCUMENTATION, INCLUDING, WITHOUT LIMITATION, ANY      ==
 == WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  ==
 == IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR ANY DAMAGES      ==
 == ARISING OUT OF THE USE, OR INABILITY TO USE, THIS SOFTWARE OR ANY   ==
 == ACCOMPANYING DOCUMENTATION, EVEN IF INFORMED IN ADVANCE OF THE      ==
 == POSSIBLITY OF SUCH DAMAGES.                                         ==
 =========================================================================
 =========================================================================*/

/*************************************************************************
 *                                                                       *
 *                   Subroutine:  dumpHdr()                              *
 *                       Author:  J. Querns, Veridian Inc (Veda)         *
 *                         Date:  14 Nov 95                              *
 *                                                                       *
 *  Description:  This routine dumps the file header(s) for the selected *
 *                ADTS sub-image polarization.  It first dumps the       *
 *                MISSION header (header-2) and then the specific sub-   *
 *                image header.  This routine has the following format:  *
 *                                                                       *
 *                int dumpHdr (infp, DUMPname, locptr)                   *
 *                                                                       *
 *                infp      -- FILE pointer to ADTS input file...        *
 *                DUMpname  -- Pointer to output header filename...      *
 *                locptr    -- Pointer to header location structure...   *
 *                                                                       *
 *************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "adts.h"


int 
dumpHdr (infp, DUMPname, locptr)

     FILE *infp;
     char *DUMPname;
     struct ADTSImgOff *locptr;

{
  FILE *DUMPfp;			/* Ptr to output header file     */
  char c;
  char *hdr2;			/* Header 2 buffer..             */
  int i;

  /* ADTS Header 1 Declarations */
  char country[5];		/* Country of origin             */
  char lab[5];			/* Originating laboratory        */
  char date[9];			/* Date data rec or gen yy mm dd */
  char dataname[9];		/* Data identifier (name)        */
  long nrecs;			/* Num of records in this file   */
  long hdr2len;			/* Num of bytes in header 2      */
  long reclen;			/* Bytes per record in this file */
  long pixent;			/* Entries per pixel...          */
  long ibytes;			/* Bytes per integer entry       */
  long mbytes;			/* Bytes per entry mantissa      */
  long ebytes;			/* Bytes per entry exponent      */
  long nsamps;			/* Samples per image line        */
  long nlines;			/* Lines per image               */
  long dvaltype;		/* Imagery data value type       */
  long auxdatatype;		/* Auxiliary data type           */
  long hdr2fmt;			/* Header 2 format               */
  long lprec;			/* Image lines per record        */

  /* Open DUMP file for Writing */

  DUMPfp = fopen (DUMPname, "a");
  if (DUMPfp == NULL)
    {
      fprintf (stderr,
	       "\n\nError[dumpHdr]: Unable to create file: [%s]", DUMPname);
      fprintf (stderr,
	       "\nReturning to calling program...\n\n");
      return 1;			/* FAILURE */
    }

/* Retrieve & Dump Sub-image header (header-1) */

  fseek (infp, locptr->hdr1, 0);
  fgets (country, 5, infp);
  fgets (lab, 5, infp);
  fgets (date, 9, infp);
  fgets (dataname, 9, infp);
  fscanf (infp,
	  "%d%d%d%d%d%d%d%d%d%d%d%d%d",
	  &nrecs, &hdr2len, &reclen, &pixent, &ibytes, &mbytes, &ebytes,
	  &nsamps, &nlines, &dvaltype, &auxdatatype, &hdr2fmt, &lprec);

  fprintf (DUMPfp, "       HEADER-1 CONTENTS\n\n");
  fprintf (DUMPfp, "%5s%5s : Country/Laboratory of origin\n", country, lab);
  fprintf (DUMPfp, "%10s : Date recorded (YY MM DD)\n", date);
  fprintf (DUMPfp, "%10s : Data Name\n", dataname);
  fprintf (DUMPfp, "%10d : Records in this file\n", nrecs);
  fprintf (DUMPfp, "%10d : Bytes in Header-2\n", hdr2len);
  fprintf (DUMPfp, "%10d : Bytes per Record\n", reclen);
  fprintf (DUMPfp, "%10d : entries per image sample\n", pixent);
  fprintf (DUMPfp, "%10d : Bytes per integer entry\n", ibytes);
  fprintf (DUMPfp, "%10d : Bytes per mantissa of an entry\n", mbytes);
  fprintf (DUMPfp, "%10d : Bytes per exponent of an entry\n", ebytes);
  fprintf (DUMPfp, "%10d : Image samples per image line\n", nsamps);
  fprintf (DUMPfp, "%10d : image lines per image\n", nlines);
  fprintf (DUMPfp, "%10d : Imagery data type\n", dvaltype);
  fprintf (DUMPfp, "%10d : Auxiliary data type\n", auxdatatype);
  fprintf (DUMPfp, "%10d : Format of Header-2\n", hdr2fmt);
  fprintf (DUMPfp, "%10d : Image line(s) per tape record\n", lprec);
  fprintf (DUMPfp, "\n");

/* Retrieve & Dump MISSION header (header-2) */

  if (locptr->hdr2len != 0)
    {
      fseek (infp, locptr->hdr2, 0);
      hdr2 = (char *) malloc (locptr->hdr2len * sizeof (char));

      if (hdr2 == NULL)
	{
	  fprintf (stderr,
		 "\n\nError[dumpHdr]: Unable to allocate header 2 memory!");
	  fprintf (stderr,
		   "\nReturning to calling program...\n\n");
	  return 1;		/* FAILURE */
	}

      fread (hdr2, sizeof (char), locptr->hdr2len, infp);

      for (i = 0; i < locptr->hdr2len; i++)
	{
	  c = hdr2[i];
	  if (c == '\r')
	    {
	      c = '\n';
	    }
	  fputc (c, DUMPfp);
	}
      fprintf (DUMPfp, "\n");
    }
  else
    {
      /* 
         No header-2 data for this pol..if header-2 exists for HH,
         use its header-2 data...
       */
      if (hhOff.hdr2len > 0)
	{
	  fseek (infp, hhOff.hdr2, 0);
	  hdr2 = (char *) malloc (hhOff.hdr2len * sizeof (char));

	  if (hdr2 == NULL)
	    {
	      fprintf (stderr,
		 "\n\nError[dumpHdr]: Unable to allocate header 2 memory!");
	      fprintf (stderr,
		       "\nReturning to calling program...\n\n");
	      return 1;		/* FAILURE */
	    }

	  fread (hdr2, sizeof (char), hhOff.hdr2len, infp);

	  for (i = 0; i < hhOff.hdr2len; i++)
	    {
	      c = hdr2[i];
	      if (c == '\r')
		{
		  c = '\n';
		}
	      fputc (c, DUMPfp);
	    }
	  fprintf (DUMPfp, "\n");
	}
      else
	{
	  printf ("\nNo header-2 data available...\n");
	}
    }

  /* Perform Cleanup */

  free (hdr2);			/* Free header 2 memory...                 */
  fclose (DUMPfp);		/* Close output file....                   */

  return 0;
}

/******************** LAST LINE OF dumpHdr() *****************************/
