/*=========================================================================
 *=========================================================================
 == [DISCLAIMER]: THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS   ==
 == RELEASED "AS IS".  THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY     ==
 == KIND, EXPRESS OR IMPLIED, CONCERNING THIS SOFTWARE AND ANY          ==
 == ACCOMPANYING DOCUMENTATION, INCLUDING, WITHOUT LIMITATION, ANY      ==
 == WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  ==
 == IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR ANY DAMAGES      ==
 == ARISING OUT OF THE USE, OR INABILITY TO USE, THIS SOFTWARE OR ANY   ==
 == ACCOMPANYING DOCUMENTATION, EVEN IF INFORMED IN ADVANCE OF THE      ==
 == POSSIBLITY OF SUCH DAMAGES.                                         ==
 =========================================================================
 =========================================================================*/

/*************************************************************************
 *                                                                       *
 *                      Routine:  disp884hdr.c                           *
 *                       Author:  J. Querns, Veridian Inc (Veda)         *
 *                                5200 Springfield Pike, Suite 200       *
 *                                Dayton, OH 45431                       *
 *                                (937) 255-1116, Ext 2818               *
 *                                                                       *
 *                         Date: 03 Jun 97                               *
 *                                                                       *
 *  Description:  This routine displays the file headers for ADTS image  *
 *                frames (all 4 polarizations, if available) to STDIN    *
 *                (screen).                                              *
 *                                                                       *
 *                This routine works on the assumption that the ADTS     *
 *                frame image has 4 sub-images, one for each polar-      *
 *                ization: HH, HV, VH, and VV.                           *
 *                                                                       *
 *                The general format of an ADTS frame image file is:     *
 *                                                                       *
 *  FRAME --> HH Subframe                       .                        * 
 *            HV Subframe                       .                        *
 *            VH Subframe -------->|   [.......EOF........]              *
 *            VV Subframe          |   [.....HEADER 1.....]              *
 *                                 |   [.....HEADER 2.....]              *
 *                                 |-->[*****884 IMAGE****]              *
 *                                     [.......EOF........]              *
 *                                              .                        *
 *                                              .                        *
 *                                                                       *
 *                 However, not all ADTS files contain both headers, so  *
 *                 this routine will not dump ADTS Header 2 unless       *
 *                 it is there.                                          *
 *                                                                       * 
 *************************************************************************
 *                                                                       *
 * Calls: getImgLoc() -- This subroutine extracts and stores offset      *
 *                       location information (image, header-1, header-2,*
 *                       header-2 length, nlines, nsamps) for every pol- *
 *                       arization sub-image...                          *
 *                                                                       *
 *************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "adts.h"

extern int getImgLoc ();	/* Extracts img & hdr locations   */

main (argc, argv)

     int argc;
     char *argv[];

{
  FILE *ADTSfp;			/* Ptr to ADTS file....           */
  char *ADTSname;		/* ADTS filename...               */
  struct ADTSImgOff *Offptr;	/* Ptr to Offset structures...    */

  int i;
  int retv;
  int poltype;
  char ans[2];
  char c;
  char *hdr2;			/* Header-2 buffer...             */

  /* ADTS Header 1 Declarations */
  char country[5];		/* Country of origin             */
  char lab[5];			/* Originating laboratory        */
  char date[9];			/* Date data rec or gen yy mm dd */
  char dataname[9];		/* Data identifier (name)        */
  long nrecs;			/* Num of records in this file   */
  long hdr2len;			/* Num of bytes in header 2      */
  long reclen;			/* Bytes per record in this file */
  long pixent;			/* Entries per pixel...          */
  long ibytes;			/* Bytes per integer entry       */
  long mbytes;			/* Bytes per entry mantissa      */
  long ebytes;			/* Bytes per entry exponent      */
  long nsamps;			/* Samples per image line        */
  long nlines;			/* Lines per image               */
  long dvaltype;		/* Imagery data value type       */
  long auxdatatype;		/* Auxiliary data type           */
  long hdr2fmt;			/* Header 2 format               */
  long lprec;			/* Image lines per record        */

  /* Check for correct arguments */

  if (argc < 2)
    {
      fprintf (stderr, "\n\n*** [ADTS 8-8-4 Image Header DISPLAY Routine] ***");
      fprintf (stderr, "\nUsage: dump884hdr <ADTS infile> \n\n");
      exit (1);
    }

  ADTSname = argv[1];

  /* Open ADTS file for Reading */

  ADTSfp = fopen (ADTSname, "rb");
  if (ADTSfp == NULL)
    {
      fprintf (stderr, "\n\nError: Unable to open file: [%s]", ADTSname);
      fprintf (stderr, "\nExiting [disp884hdr] program...\n\n");
      exit (1);			/* FAILURE */
    }

/****************************************************************************
 *                        Get File Offset Location Data                     *
 *                            (on all polarizations)                        *
 ****************************************************************************/

  if ((retv = getImgLoc (ADTSfp)) != 0)
    {
      fprintf (stderr, "\n\nError: in obtaining offset location data");
      fprintf (stderr, "\nExiting [disp884hdr] program...\n\n");
      fclose (ADTSfp);
      exit (1);
    }

	   /****************************************************
	    *                     DUMP HEADERS                 *
	    ****************************************************/

  printf ("\n\nADTS 8-8-4 Header Display for file: [%s]", ADTSname);

  for (poltype = 0; poltype < 4; poltype++)
    {
      ans[0] = '\0';
      switch (poltype)
	{
	case 0:		/* HH */
	  Offptr = &hhOff;
	  printf ("\n    [HH] HEADER-1 CONTENTS\n\n");
	  break;
	case 1:		/* HV */
	  Offptr = &hvOff;

	  printf ("\nContinue (y/n)? > ");
	  scanf ("%s", ans);
	  if ((strcmp (ans, "y") != 0) &&
	      (strcmp (ans, "Y") != 0))
	    {
	      fclose (ADTSfp);
	      printf ("\nExiting [disp884hdr] program...\n\n");
	      exit (1);
	    }
	  else
	    {
	      printf ("\n    [HV] HEADER-1 CONTENTS\n\n");
	    }
	  break;
	case 2:		/* VH */
	  Offptr = &vhOff;

	  printf ("\nContinue (y/n)? > ");
	  scanf ("%s", ans);
	  if ((strcmp (ans, "y") != 0) &&
	      (strcmp (ans, "Y") != 0))
	    {
	      fclose (ADTSfp);
	      printf ("\nExiting [disp884hdr] program...\n\n");
	      exit (1);
	    }
	  else
	    {
	      printf ("\n    [VH] HEADER-1 CONTENTS\n\n");
	    }
	  break;
	case 3:		/* VV */
	  Offptr = &vvOff;

	  printf ("\nContinue (y/n)? > ");
	  scanf ("%s", ans);
	  if ((strcmp (ans, "y") != 0) &&
	      (strcmp (ans, "Y") != 0))
	    {
	      fclose (ADTSfp);
	      printf ("\nExiting [disp884hdr] program...\n\n");
	      exit (1);
	    }
	  else
	    {
	      printf ("\n    [VV] HEADER-1 CONTENTS\n\n");
	    }
	  break;
	}

      fseek (ADTSfp, Offptr->hdr1, 0);
      fgets (country, 5, ADTSfp);
      fgets (lab, 5, ADTSfp);
      fgets (date, 9, ADTSfp);
      fgets (dataname, 9, ADTSfp);
      fscanf (ADTSfp,
	      "%d%d%d%d%d%d%d%d%d%d%d%d%d",
	      &nrecs, &hdr2len, &reclen, &pixent, &ibytes, &mbytes, &ebytes,
	      &nsamps, &nlines, &dvaltype, &auxdatatype, &hdr2fmt, &lprec);

      printf ("%5s%5s : Country/Laboratory of origin\n", country, lab);
      printf ("%10s : Date recorded (YY MM DD)\n", date);
      printf ("%10s : Data Name\n", dataname);
      printf ("%10d : Records in this file\n", nrecs);
      printf ("%10d : Bytes in Header-2\n", hdr2len);
      printf ("%10d : Bytes per Record\n", reclen);
      printf ("%10d : entries per image sample\n", pixent);
      printf ("%10d : Bytes per integer entry\n", ibytes);
      printf ("%10d : Bytes per mantissa of an entry\n", mbytes);
      printf ("%10d : Bytes per exponent of an entry\n", ebytes);
      printf ("%10d : Image samples per image line\n", nsamps);
      printf ("%10d : image lines per image\n", nlines);
      printf ("%10d : Imagery data type\n", dvaltype);
      printf ("%10d : Auxiliary data type\n", auxdatatype);
      printf ("%10d : Format of Header-2\n", hdr2fmt);
      printf ("%10d : Image line(s) per tape record\n", lprec);
      printf ("\n");

    }				/* End of FOR loop */

  /* Retrieve & Dump MISSION header (header-2) */

  ans[0] = '\0';
  printf ("\nContinue (y/n)? > ");
  scanf ("%s", ans);
  if ((strcmp (ans, "y") != 0) &&
      (strcmp (ans, "Y") != 0))
    {
      fclose (ADTSfp);
      printf ("\nExiting [disp884hdr] program...\n\n");
      exit (1);
    }

  if (hhOff.hdr2len > 0)
    {
      fseek (ADTSfp, hhOff.hdr2, 0);
      hdr2 = (char *) malloc (hhOff.hdr2len * sizeof (char));

      if (hdr2 == NULL)
	{
	  fprintf (stderr, "\n\nError: Unable to allocate header 2 memory!");
	  fprintf (stderr, "\nExiting [disp884hdr] program...\n\n");
	  fclose (ADTSfp);
	  exit (1);
	}
      else
	{
	  fread (hdr2, sizeof (char), hhOff.hdr2len, ADTSfp);

	  for (i = 0; i < hhOff.hdr2len; i++)
	    {
	      c = hdr2[i];
	      if (c == '\r')
		{
		  c = '\n';
		}
	      printf ("%c", c);
	    }
	  printf ("\n\nEnd of header display...\n\n");
	}
    }
  else
    {
      printf ("\n\nNo MISSION HEADER (Header-2)\n\n");
    }

  /* Cleanup -- Close files */

  fclose (ADTSfp);		/* Close input file....                    */

  printf ("\nADTS Header Display complete...\n\n");

}

/******************** LAST LINE OF disp884hdr() *****************************/
