/*=========================================================================
 *=========================================================================
 == [DISCLAIMER]: THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS   ==
 == RELEASED "AS IS".  THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY     ==
 == KIND, EXPRESS OR IMPLIED, CONCERNING THIS SOFTWARE AND ANY          ==
 == ACCOMPANYING DOCUMENTATION, INCLUDING, WITHOUT LIMITATION, ANY      ==
 == WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  ==
 == IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR ANY DAMAGES      ==
 == ARISING OUT OF THE USE, OR INABILITY TO USE, THIS SOFTWARE OR ANY   ==
 == ACCOMPANYING DOCUMENTATION, EVEN IF INFORMED IN ADVANCE OF THE      ==
 == POSSIBLITY OF SUCH DAMAGES.                                         ==
 =========================================================================
 =========================================================================*/

/*************************************************************************
 *                                                                       *
 *                      Routine:  dump884hdr.c                           *
 *                       Author:  J. Querns, Veridian Inc (Veda)         *
 *                                5200 Springfield Pike, Suite 200       *
 *                                Dayton, OH 45431                       *
 *                                (937) 255-1116, Ext 2818               *
 *                                                                       *
 *                         Date: 3 Jun 97                                *
 *                                                                       *
 *  Description:  This routine dumps the file headers for ADTS image     *
 *                frames (all 4 polarizations, if available) to an ex-   *
 *                ternal file.  The external file will have the name you *
 *                select, so call it what you will...                    *
 *                                                                       *
 *                This routine works on the assumption that the ADTS     *
 *                frame image has 4 sub-images, one for each polar-      *
 *                ization: HH, HV, VH, and VV.                           *
 *                                                                       *
 *                The general format of an ADTS frame image file is:     *
 *                                                                       *
 *  FRAME --> HH Subframe                       .                        * 
 *            HV Subframe                       .                        *
 *            VH Subframe -------->|   [.......EOF........]              *
 *            VV Subframe          |   [.....HEADER 1.....]              *
 *                                 |   [.....HEADER 2.....]              *
 *                                 |-->[*****884 IMAGE****]              *
 *                                     [.......EOF........]              *
 *                                              .                        *
 *                                              .                        *
 *                                                                       *
 *                 However, not all ADTS files contain both headers, so  *
 *                 this routine will not dump ADTS Header 2 unless       *
 *                 it is there.                                          *
 *                                                                       * 
 *************************************************************************
 *                                                                       *
 * Calls: getImgLoc() -- This subroutine extracts and stores offset      *
 *                       location information (image, header-1, header-2,*
 *                       header-2 length, nlines, nsamps) for every pol- *
 *                       arization sub-image...                          *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "adts.h"

extern int getImgLoc ();	/* Extracts img & hdr locations   */

main (argc, argv)

     int argc;
     char *argv[];

{
  FILE *ADTSfp;			/* Ptr to ADTS file....           */
  FILE *HDRfp;			/* Ptr to Header file...          */
  char *ADTSname;		/* ADTS filename...               */
  char *HDRname;		/* Header output filename...      */
  struct ADTSImgOff *Offptr;	/* Ptr to Offset structures...    */

  int i;
  int retv;
  int poltype;
  char c;
  char *hdr2;			/* Header-2 buffer...             */

  /* ADTS Header 1 Declarations */
  char country[5];		/* Country of origin             */
  char lab[5];			/* Originating laboratory        */
  char date[9];			/* Date data rec or gen yy mm dd */
  char dataname[9];		/* Data identifier (name)        */
  long nrecs;			/* Num of records in this file   */
  long hdr2len;			/* Num of bytes in header 2      */
  long reclen;			/* Bytes per record in this file */
  long pixent;			/* Entries per pixel...          */
  long ibytes;			/* Bytes per integer entry       */
  long mbytes;			/* Bytes per entry mantissa      */
  long ebytes;			/* Bytes per entry exponent      */
  long nsamps;			/* Samples per image line        */
  long nlines;			/* Lines per image               */
  long dvaltype;		/* Imagery data value type       */
  long auxdatatype;		/* Auxiliary data type           */
  long hdr2fmt;			/* Header 2 format               */
  long lprec;			/* Image lines per record        */

  /* Check for correct arguments */

  if (argc < 3)
    {
      fprintf (stderr, "\n\n*** [ADTS 8-8-4 Image Header DUMP Routine] ***");
      fprintf (stderr, "\nUsage: dump884hdr <ADTS infile> <Header outfile>\n\n");
      exit (1);
    }

  ADTSname = argv[1];
  HDRname = argv[2];

  /* Open ADTS file for Reading */

  ADTSfp = fopen (ADTSname, "rb");
  if (ADTSfp == NULL)
    {
      fprintf (stderr, "\n\nError: Unable to open file: [%s]", ADTSname);
      fprintf (stderr, "\nExiting [dump884hdr] program...\n\n");
      exit (1);			/* FAILURE */
    }

/****************************************************************************
 *                        Get File Offset Location Data                     *
 *                            (on all polarizations)                        *
 ****************************************************************************/

  if ((retv = getImgLoc (ADTSfp)) != 0)
    {
      fprintf (stderr, "\n\nError: in obtaining offset location data");
      fprintf (stderr, "\nExiting [dump884hdr] program...\n\n");
      fclose (ADTSfp);
      exit (1);
    }

	   /****************************************************
	    *                     DUMP HEADERS                 *
	    ****************************************************/

  printf ("\n\nADTS 8-8-4 Header Dump for file: [%s]", ADTSname);
  printf ("\n  Dumping ADTS 8-8-4 headers to: [%s]", HDRname);

  /* Create (Open) HEADER file for Appending */

  HDRfp = fopen (HDRname, "a");
  if (HDRfp == NULL)
    {
      fprintf (stderr, "\n\nError: Unable to create file: [%s]", HDRname);
      fprintf (stderr, "\nExiting [dump884hdr] program...\n\n");
      fclose (ADTSfp);
      exit (1);
    }

  fprintf (HDRfp, "\nADTS 8-8-4 Header Dump for file: [%s]\n", ADTSname);

  for (poltype = 0; poltype < 4; poltype++)
    {
      switch (poltype)
	{
	case 0:		/* HH */
	  Offptr = &hhOff;
	  fprintf (HDRfp, "\n    [HH] HEADER-1 CONTENTS\n\n");
	  break;
	case 1:		/* HV */
	  Offptr = &hvOff;
	  fprintf (HDRfp, "\n    [HV] HEADER-1 CONTENTS\n\n");
	  break;
	case 2:		/* VH */
	  Offptr = &vhOff;
	  fprintf (HDRfp, "\n    [VH] HEADER-1 CONTENTS\n\n");
	  break;
	case 3:		/* VV */
	  Offptr = &vvOff;
	  fprintf (HDRfp, "\n    [VV] HEADER-1 CONTENTS\n\n");
	  break;
	}

      fseek (ADTSfp, Offptr->hdr1, 0);
      fgets (country, 5, ADTSfp);
      fgets (lab, 5, ADTSfp);
      fgets (date, 9, ADTSfp);
      fgets (dataname, 9, ADTSfp);
      fscanf (ADTSfp,
	      "%d%d%d%d%d%d%d%d%d%d%d%d%d",
	      &nrecs, &hdr2len, &reclen, &pixent, &ibytes, &mbytes, &ebytes,
	      &nsamps, &nlines, &dvaltype, &auxdatatype, &hdr2fmt, &lprec);

      fprintf (HDRfp, "%5s%5s : Country/Laboratory of origin\n", country, lab);
      fprintf (HDRfp, "%10s : Date recorded (YY MM DD)\n", date);
      fprintf (HDRfp, "%10s : Data Name\n", dataname);
      fprintf (HDRfp, "%10d : Records in this file\n", nrecs);
      fprintf (HDRfp, "%10d : Bytes in Header-2\n", hdr2len);
      fprintf (HDRfp, "%10d : Bytes per Record\n", reclen);
      fprintf (HDRfp, "%10d : entries per image sample\n", pixent);
      fprintf (HDRfp, "%10d : Bytes per integer entry\n", ibytes);
      fprintf (HDRfp, "%10d : Bytes per mantissa of an entry\n", mbytes);
      fprintf (HDRfp, "%10d : Bytes per exponent of an entry\n", ebytes);
      fprintf (HDRfp, "%10d : Image samples per image line\n", nsamps);
      fprintf (HDRfp, "%10d : image lines per image\n", nlines);
      fprintf (HDRfp, "%10d : Imagery data type\n", dvaltype);
      fprintf (HDRfp, "%10d : Auxiliary data type\n", auxdatatype);
      fprintf (HDRfp, "%10d : Format of Header-2\n", hdr2fmt);
      fprintf (HDRfp, "%10d : Image line(s) per tape record\n", lprec);
      fprintf (HDRfp, "\n\n");

    }				/* End of FOR loop */

  /* Retrieve & Dump MISSION header (header-2) */

  if (hhOff.hdr2len > 0)
    {
      fseek (ADTSfp, hhOff.hdr2, 0);
      hdr2 = (char *) malloc (hhOff.hdr2len * sizeof (char));

      if (hdr2 == NULL)
	{
	  fprintf (stderr, "\n\nError: Unable to allocate header 2 memory!");
	  fprintf (stderr, "\nExiting [dump884hdr] program...\n\n");
	  fclose (ADTSfp);
	  fclose (HDRfp);
	  exit (1);
	}
      else
	{
	  fread (hdr2, sizeof (char), hhOff.hdr2len, ADTSfp);

	  for (i = 0; i < hhOff.hdr2len; i++)
	    {
	      c = hdr2[i];
	      if (c == '\r')
		{
		  c = '\n';
		}
	      fputc (c, HDRfp);
	    }
	  fprintf (HDRfp, "\n\nEnd of header dump...\n\n");
	}
    }
  else
    {
      fprintf (HDRfp, "\n\nNo MISSION HEADER (Header-2)\n\n");
    }

  /* Cleanup -- Close files */

  fclose (ADTSfp);		/* Close input file....                    */
  fclose (HDRfp);		/* Close header dump file...               */

  printf ("\nADTS Header Dump to [%s] complete...\n\n", HDRname);

}

/******************** LAST LINE OF dump884hdr() *****************************/
