/*=========================================================================
 *=========================================================================
 == [DISCLAIMER]: THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS   ==
 == RELEASED "AS IS".  THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY     ==
 == KIND, EXPRESS OR IMPLIED, CONCERNING THIS SOFTWARE AND ANY          ==
 == ACCOMPANYING DOCUMENTATION, INCLUDING, WITHOUT LIMITATION, ANY      ==
 == WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  ==
 == IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR ANY DAMAGES      ==
 == ARISING OUT OF THE USE, OR INABILITY TO USE, THIS SOFTWARE OR ANY   ==
 == ACCOMPANYING DOCUMENTATION, EVEN IF INFORMED IN ADVANCE OF THE      ==
 == POSSIBLITY OF SUCH DAMAGES.                                         ==
 =========================================================================
 =========================================================================*/

/*************************************************************************
 *                                                                       *
 *                      Routine:  hdr884.c                               *
 *                       Author:  J. Querns, Veda Inc.                   *
 *                                5200 Springfield Pike, Suite 200       *
 *                                Dayton, OH 45431                       *
 *                                (937) 255-1116                         *
 *                                                                       *
 *                         Date: 3 Jun 97                                *
 *                                                                       *
 *  Description:  This routine displays the file headers for a single    *
 *                polarization image in the 8-8-4 format to STDOUT.      *
 *                                                                       *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

main (argc, argv)

     int argc;
     char **argv;

{
  FILE *infp;			/* Ptr to 8-8-4 file....          */
  char *INname;			/* 8-8-4 filename...              */

  char ans[2];
  char c;
  char *hdr2;			/* Header-2 buffer...             */
  int i;
  long n;

  /* 8-8-4 Header 1 Declarations */
  char country[5];		/* Country of origin             */
  char lab[5];			/* Originating laboratory        */
  char date[9];			/* Date data rec or gen yy mm dd */
  char dataname[9];		/* Data identifier (name)        */
  long nrecs;			/* Num of records in this file   */
  long hdr2len;			/* Num of bytes in header 2      */
  long reclen;			/* Bytes per record in this file */
  long pixent;			/* Entries per pixel...          */
  long ibytes;			/* Bytes per integer entry       */
  long mbytes;			/* Bytes per entry mantissa      */
  long ebytes;			/* Bytes per entry exponent      */
  long nsamps;			/* Samples per image line        */
  long nlines;			/* Lines per image               */
  long dvaltype;		/* Imagery data value type       */
  long auxdatatype;		/* Auxiliary data type           */
  long hdr2fmt;			/* Header 2 format               */
  long lprec;			/* Image lines per record        */


  /* Check for correct arguments */

  if (argc < 2)
    {
      fprintf (stderr, "\n\n[Display (Single) 8-8-4 Image Header(s)]");
      fprintf (stderr,
	       "\nUsage: hdr884 <884-Image file>\n\n");
      exit (1);
    }

  INname = argv[1];		/* Retrieve 8-8-4 image input name           */

  /* Open 8-8-4 file for Reading */

  infp = fopen (INname, "rb");
  if (infp == NULL)
    {
      fprintf (stderr, "\n\nError[hdr884]: Unable to open file: [%s]", INname);
      fprintf (stderr, "\nExiting [hdr884] program...\n\n");
      exit (1);			/* FAILURE */
    }

  /* Retrieve Header-1 Contents */

  fgets (country, 5, infp);
  fgets (lab, 5, infp);
  fgets (date, 9, infp);
  fgets (dataname, 9, infp);
  fscanf (infp,
	  "%d%d%d%d%d%d%d%d%d%d%d%d%d",
	  &nrecs, &hdr2len, &reclen, &pixent, &ibytes, &mbytes, &ebytes,
	  &nsamps, &nlines, &dvaltype, &auxdatatype, &hdr2fmt, &lprec);

  /* Display Header-1 Contents */

  printf ("\n");
  printf ("\nHEADER-1: [8-8-4 FORMAT IMAGE PARAMETERS] \n\n");
  printf ("%5s%5s : Country/Laboratory of origin\n", country, lab);
  printf ("%10s : Date recorded (YY MM DD)\n", date);
  printf ("%10s : Data Name\n", dataname);
  printf ("%10d : Records in this file\n", nrecs);
  printf ("%10d : Bytes in Header-2\n", hdr2len);
  printf ("%10d : Bytes per Record\n", reclen);
  printf ("%10d : entries per image sample\n", pixent);
  printf ("%10d : Bytes per integer entry\n", ibytes);
  printf ("%10d : Bytes per mantissa of an entry\n", mbytes);
  printf ("%10d : Bytes per exponent of an entry\n", ebytes);
  printf ("%10d : Image samples per image line\n", nsamps);
  printf ("%10d : image lines per image\n", nlines);
  printf ("%10d : Imagery data type\n", dvaltype);
  printf ("%10d : Auxiliary data type\n", auxdatatype);
  printf ("%10d : Format of Header-2\n", hdr2fmt);
  printf ("%10d : Image line(s) per tape record\n", lprec);
  printf ("\n");

  /* Retrieve Header-2 Contents, if there and-or desired */

  if (hdr2len > 0)
    {
      ans[0] = '\0';
      printf ("\nDisplay Header-2 contents (y/n)? > ");
      scanf ("%s", ans);
      if ((strcmp (ans, "y") != 0) &&
	  (strcmp (ans, "Y") != 0))
	{
	  fclose (infp);
	  printf ("\nExiting [hdr884] program...\n\n");
	  exit (1);
	}
    }
  /* Display Header-2 Contents */

  hdr2 = (char *) malloc (hdr2len * sizeof (char));

  if (hdr2 == NULL)
    {
      fprintf (stderr, "\n\nError: Unable to allocate header 2 memory!");
      fprintf (stderr, "\nExiting [hdr884] program...\n\n");
      fclose (infp);
      exit (1);
    }

  fseek (infp, reclen, 0);	/* Seek to start of header-2 */
  n = fread (hdr2, sizeof (char), hdr2len, infp);

  if (n != hdr2len)
    {
      fprintf (stderr, "\n\nError[hdr884]: in reading header-2 data!");
      fprintf (stderr, "\nOnly read [%ld] of [%ld] bytes\n\n", n, hdr2len);
      fclose (infp);
      free (hdr2);
      exit (1);
    }

  printf ("\n\nHEADER-2: [8-8-4 FORMAT MISSION PARAMETERS] \n\n");
  for (i = 0; i < hdr2len; i++)
    {
      c = hdr2[i];
      if (c == '\r')
	{
	  c = '\n';
	}
      printf ("%c", c);
    }

  printf ("\n\nEnd of header display...\n\n");









}
/******************** LAST LINE OF hdr884() *****************************/
