/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: get_func                                                */
/*/
   /* Created: 9 Dec 1994 by F. C. Betts - Veda Incorporated              */
/*/
   /* Purpose: get_func scans the translation file for the next keyword=  */
/* string and parses the string up to and including the =   */
/* as well as the location into a start and stop character  */
/* position, the func, any modifiers and data and finally   */
/* the remainder of the line which can be comments to be    */
/* appended to the data.                                    */
/*/
   /* Last Update: work in progress 18 Jan 1995 by fcb                    */
/* added feature to escape func processing if ' char in   */
/* in address - 6 Feb 1995 by fcb                                */
/* added feature to escape func processing if " char in   */
/* address - also terminates comment processing to allow  */
/* quoted fields to be put inline - 9 May 1995 by fcb     */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

int get_mods ();

int
get_func ()

{
  extern char keyword_string[150];	/* part of keyword= string */
  extern int data_address_start;	/* first byte of data in data file */
  extern int data_address_end;	/* last byte of data in data file */
  extern char func[10];		/* function string */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char comments[150];	/* remainder of keyword string */
  extern int eol;


  extern FILE *fptrxlate, *fpttmp;	/* file handle  */

  int ch;			/* input character from translation file -

				 * one at a time */
  int state = 0;		/* state mode flag    0 = scanning for = flag

				 * all chars sent to key word_string 1 =
				 * reading address characters 2 = reading
				 * func characters 5 = reading comments 6 =
				 * EOF */
  int first_address_flag;	/* first address flag */
  int keyword_count = 0;	/* keyword character string count */
  int func_count = 0;		/* func character string count */
  int comments_count = 0;	/* comments character string count */
  int result_get_mods = 0;	/* results of calling get_mods */

  data_address_start = 0;
  data_address_end = 0;
  memset (func, '\0', 10);
  memset (keyword_string, '\0', 150);
  memset (mod1, '\0', 10);
  memset (mod2, '\0', 10);
  memset (comments, '\0', 150);


  /* printf("got to get_func%d\n"); */
  /* reset the state variables */
  state = 0;
  ch = 0;
  keyword_count = 0;
  comments_count = 0;
  func_count = 0;
  eol = 0;

  while ((ch = getc (fptrxlate)) != EOF)	/* get character from file */

    {

      /* show the characters as they are processed */
      /* printf("%c",ch); */

      if (state == 0)		/* process front of string */
	{

	  /* save the character and increment the count */
	  *(keyword_string + keyword_count++) = ch;

	  if (ch == '\n')	/* check for new line */
	    {
	      *(keyword_string + keyword_count) = '\0';
	      return (state);
	    }
	  if (ch == ';')	/* escape the key to do comments only */
	    {
	      state = 5;	/* set to do comments processing */
	      /* printf("found ignore char\n"); */
	      continue;
	    }
	  if (ch == '=')	/* check for keyword = */
	    {
	      *(keyword_string + keyword_count) = '\0';
	      /* printf("\n<switching to address processing>\n"); */
	      state = 1;
	      data_address_start = 0;
	      data_address_end = 0;
	      first_address_flag = 0;
	      continue;
	    }
	  if (ch == '\\')	/* check for backspace */
	    {
	      eol = 1;
	      continue;
	    }
	}
      if (state == 1)		/* process address */


	{
	  if (ch == '\'')	/* escape the address to do comments only */
	    {
	      state = 5;	/* set to do comments processing */
	      /* printf("found escape to comments char\n"); */
	      continue;
	    }
	  if (ch == '\"')	/* escape the address to do quote */
	    {
	      state = 5;	/* set to do quote processing */
	      /* printf("found escape to quote char\n"); */
	      continue;
	    }
	  if (ch == ',')	/* end of address entry */
	    {
	      if (first_address_flag == 0)	/* second field not entered - set to
						   * 1st */
		{
		  data_address_end = data_address_start;
		}
	      state = 2;
	      func_count = 0;
	      /* printf("address start-stop =%d,%d\n",
	         * data_address_start,data_address_end); printf("<switching to func
	         * processing>\n"); */
	      continue;
	    }
	  if (ch == '-')	/* transition to second address */
	    {
	      first_address_flag = 1;
	    }
	  if (ch == '\\')	/* check for backspace */
	    {
	      eol = 1;
	      continue;
	    }
	  if ((ch > 47) && (ch < 58))	/* make sure its a number character -
					 * ignore else */
	    {
	      if (first_address_flag == 0)
		{
		  data_address_start = data_address_start * 10 +
		      (ch - 48);
		}
	      else
		{
		  data_address_end = data_address_end * 10 +
		      (ch - 48);
		}
	    }
	}
      if (state == 2)		/* func process */

	{

	  if (ch == 44)		/* end of func string - comma */
	    {
	      state = 5;	/* switch to comments processing */
	      *(func + func_count) = '\0';	/* terminate func string */
	      comments_count = 0;	/* initialize commments counter */
	      /* printf("\n<switching to comments processing>\n"); */
	      continue;
	    }
	  /* test for newline character - indicates no modifiers */
	  if (ch == '\n')	/* end of func string line */
	    {
	      *(func + func_count) = '\0';	/* terminate func string */
	      return (state);
	    }
	  if (ch == '\\')	/* check for backspace */
	    {
	      eol = 1;
	      continue;
	    }
	  /* save the character in the func string */
	  *(func + func_count++) = ch;

	}
      if (state == 5)		/* comments processing */
	{
	  if (ch == '\"')	/* check for quote */
	    {
	      *(comments + comments_count) = '\0';
	      return (state);
	    }
	  if (ch == '=')	/* check for equals */
	    {
	      *(comments + comments_count++) = ch;
	      *(comments + comments_count) = '\0';
	      return (state);
	    }
	  if (ch == '\n')	/* check for new line */
	    {
	      *(comments + comments_count++) = ch;
	      *(comments + comments_count) = '\0';

	      /* this is the easiest place to do modifier scans */
	      result_get_mods = get_mods ();
	      if (result_get_mods)
		{
		  fprintf (stderr,
			   "problem with get_mods in get_func\n");
		  exit (1);
		}
	      /* if(strlen(mod1)!=0) printf("get_func mod1 =>%s<\n",mod1);
	         * if(strlen(mod2)!=0) printf("get_func mod2 =>%s<\n",mod2); */

	      return (state);
	    }
	  if (ch == '\\')	/* check for backspace */
	    {
	      eol = 1;
	      continue;
	    }
	  /* save the character in the comments string and increment the counter */
	  *(comments + comments_count++) = ch;
	}
    }

  /* must be eof */
  state = 6;
  clearerr (fptrxlate);
  return (state);
}
