/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /*  Subroutine: get_mods.c                                              */
/*/
   /*  Created: 06 Jan 1995 by F. C. Betts - Veda Incorporated             */
/*/
   /*  Purpose: get_mods scans the comments string for modifier strings    */
/*      Currently there are two allowable mods.  They are:              */
/*      1)      mult <value>    - meaning multiply result by this value */
/*      2)      offset <value>  - meaning add offset value to result    */
/*/
   /*  Last Update: work in progress 16 Jan 1995 by fcb                    */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include <stdlib.h>		/* needed for atof function */
#include "phxlate.h"

/* called subroutine */
int get_value ();

int
get_mods ()

{
  extern char comments[150];	/* remainder of keyword string */

  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */

  char temp_buff[50], temp_char;
  int ipoint, buffer_len, results;

  /* printf("\nget_mods processing, comments=>%s<\n",comments); */

  results = 0;

  /* first check for an allowable mod string */
  if ((strlen (comments) > 3) && (strncmp ("mult", comments, 4) == 0))
    {
      strcpy (mod1, "mult");
      /* printf("found mult string first\n"); */
      /* throw away the mult characters */
      strcpy (&comments[0], &comments[4]);
      /* get the value from the comments string */
      results = get_value (&multiplier_value);
    }
  else if ((strlen (comments) > 5) && (strncmp ("offset", comments, 6) == 0))
    {
      strcpy (mod1, "offset");
      /* printf("found offset string first\n"); */
      /* throw away the offset characters */
      strcpy (&comments[0], &comments[6]);
      results = get_value (&offset_value);
    }

  /* first check for an allowable mod string */
  if ((strlen (comments) > 3) && (strncmp ("mult", comments, 4) == 0))
    {
      strcpy (mod2, "mult");
      /* printf("found mult string second\n"); */
      /* throw away the mult characters */
      strcpy (&comments[0], &comments[4]);
      /* get the value from the comments string */
      results = get_value (&multiplier_value);
    }
  else if ((strlen (comments) > 5) && (strncmp ("offset", comments, 6) == 0))
    {
      strcpy (mod2, "offset");
      /* printf("found offset string second\n"); */
      /* throw away the offset characters */
      strcpy (&comments[0], &comments[6]);
      results = get_value (&offset_value);
    }
  /* check for errors */
  if (results)
    {
      fprintf (stderr, "problem with get_value in get_mods\n");
      return (1);
    }
  else
    /* all done - leave */
    return (0);
}
