/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: get_val.c                                                 */
/*/
   /* Created: 06 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: get_val scans the comments string for modifier value         */
/* Currently there are two allowable mods.  They are:            */
/* 1)   mult <value>    - meaning multiply result by this value  */
/* 2)   offset <value>  - meaning add offset value to result     */
/*/
   /* Last Update: work in progress 16 Jan 1995 by fcb                      */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include <stdlib.h>		/* needed for atof function */
#include "phxlate.h"

int
get_value (temp_value)
     double *temp_value;
{
  extern char comments[150];	/* remainder of keyword string */

  char temp_buff[50], temp_char;
  int ipoint, buffer_len;

  /* scan for comma delimiter or end of comments */
  buffer_len = strlen (comments);
  for (ipoint = 0; ipoint < buffer_len; ipoint++)
    {
      /* printf("ipoint=%d, buffer_len=%d\n",ipoint,buffer_len); */

      /* check for comma */
      memcpy (&temp_char, &comments[ipoint], 1);

      /* printf("temp_char=>%c< ipoint=%d\n",temp_char,ipoint); */

      if ((temp_char == ',') || (temp_char == '\n'))
	{
	  /* copy the value to a temp buffer */
	  memset (temp_buff, '\0', 50);
	  memcpy (temp_buff, comments, ipoint);
	  /* printf("get_value temp_buff=>%s<\n",temp_buff); */

	  /* convert buffer to a value */
	  *temp_value = atof (temp_buff);
	  /* printf("get_value temp_value=>%g<\n",*temp_value); */

	  /* shift the comments to remove value */
	  strcpy (&comments[0], &comments[ipoint + 1]);

	  /* done processing */
	  break;
	}
    }

  /* all done - leave */
  return (0);
}
