/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Program: openfils                                                   */
/*/
   /* Created: 5 Dec 1994 by F. C. Betts - Veda Incorporated              */
/*/
   /* Purpose: openfils uses the argument line of the call to phxlate     */
/* to open the files needed by phxlate                       */
/*/
   /* Last Update: work in progress 6 Feb 1995 by fcb                     */
/* modified 9 Feb 95 to standard io only by fcb          */
/* modified 23 Feb 95 to the -l option by fcb            */
/* rewritten 14 June 95                                          */
/* made options -t, -n, -s  DEH                  */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include <fcntl.h>		/* needed for Oflags   */
#include "phxlate.h"

int
openfils (argc, argv)
     int argc;
     char *argv[];
{
  extern FILE *fptorig, *fptrxlate, *fpttmp, *fptcnvt;
  extern long native_hdr_length, total_sig_length;
  extern char *fname;
  int table_open_flag = FALSE;
  char temp_char;
  int argnum;
  char *temp;
  int non_dash_arg_num, n_set = FALSE;
  void print_usage ();


  non_dash_arg_num = 1;
  for (argnum = 1; argnum < argc; argnum++)
    {
      temp = argv[argnum];
      if (temp[0] != '-')
	{
	  switch (non_dash_arg_num)
	    {
	    case 1:
	      if ((fptorig = fopen (temp, "rb")) == NULL)
		{
		  fprintf (stderr, "Can't open file %s.\n", temp);
		  return (1);
		}
	      break;
	    case 2:
	      if ((fptcnvt = fopen (temp, "w+b")) == NULL)
		{
		  fprintf (stderr, "\
Sorry file %s already exits! Stopping!.\n", temp);
		  return (1);
		}
	      fname = argv[argnum];
	      break;
	    default:
	      fprintf (stderr, "Arguments not in proper form - Stopping\n");
	      exit (1);
	      break;
	    }
	  non_dash_arg_num++;
	}
      else
	{
	  temp++;
	  switch (*(temp++))
	    {
	    case 't':
	      if (temp[0] == '\0')
		temp = argv[++argnum];
	      if ((fptrxlate = fopen (temp, "rb")) == NULL)
		{
		  fprintf (stderr, "Can't open file %s.\n", temp);
		  return (1);
		}
	      table_open_flag = TRUE;
	      break;

	    case 's':
	      if (temp[0] == '\0')
		temp = argv[++argnum];
	      total_sig_length = atol (temp);
	      break;

	    case 'n':
	      if (temp[0] == '\0')
		temp = argv[++argnum];
	      native_hdr_length = atol (temp);
	      n_set = TRUE;
	      break;

	    default:
	      fprintf (stderr, "Error: Unknown switch %s%20s\n",
		       argv[argnum], " ");
	      exit (1);
	      break;
	    }
	}
    }				/* end for argnum = 1..#args */


  if ((non_dash_arg_num != 2 + 1) || !n_set)
    {
      print_usage ();
      exit (1);
    }
  if (!table_open_flag)
    {
      if ((fptrxlate = fopen ("phxlate.pxt", "rb")) == NULL)
	{
	  fprintf (stderr, "Can't open file %s.\n", "phxlate.pxt");
	  return (1);
	}
    }
  /* open the temp file that is used to store the phoenix header */
  if ((fpttmp = fopen ("tmp001", "w+b")) == NULL)
    {
      fprintf (stderr, "Can't open tmp file! - Stopping! \n");
      return (1);
    }
  /* all is well with the world! */
  return (0);
}



/**************************************************************************

 * print_usage  This function prints the usage message to stderr.
 *
 **************************************************************************/

void
print_usage ()
{
  char str[256];

  fprintf (stderr, "\
usage: phxlate.platform <Input filename> <Output filename>\n\
-n<native header length> [-t<translation table filename>] \n\
[-s<signature length> \n");

  exit (1);
}
