/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Program: phxlate                                                    */
/*/
   /* Created: 1 Dec 1994 by F. C. Betts - Veda Incorporated              */
/*/
   /* Purpose: phxlate uses a translation table to create a               */
/* Phoenix Header from data accessed from the              */
/* originalfile.  The Phoenix Header with the              */
/* original file appended is then written to               */
/* the convertedfile.                                      */
/*/
   /* the command line has the following syntax:                 */
/* phxlate [-t translationfile] originalfile convertedfile */
/*/
   /* if the -t and translationfile is not present, the program  */
/* searches the current directory for file phxlate.pxt     */
/*/
   /* Last Update: work in progress 6 Feb 1994 by fcb                     */
/* 8 Feb 95 - changed to all stdio functions - fcb               */
/* 23 Feb 95 - changed buffsiz1 to 1024 - fcb            */
/* 24 Feb 95 - added ; ignore flag to xlate table - fcb  */
/* 10 May 95 - added quote, ==, put_i2 - ver .02 - fcb           */
/* 12 May 95 - changed header style - ver .03 - fcb      */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

char buff[BUFFSIZ1];
FILE *fptorig, *fptrxlate, *fpttmp, *fptcnvt;	/* file handles  */
char *fname;			/* output filename */
char keyword_string[150];	/* front end of keyword= string */
int data_address_start;		/* start byte address of data */
int data_address_end;		/* end byte address of data */
char func[10];			/* function string */
char mod1[10];			/* modifier 1 if present */
char mod2[10];			/* modifier 2 if present */
char comments[150];		/* remainder of keyword string */
double multiplier_value;	/* mult mod value */
double offset_value;		/* offset add value */
int swap_bytes;			/* true if bytes must be swapped on this

				 * machine */
long total_sig_length = 24576;	/* record length in bytes of

				   * native record */
long native_hdr_length = 24576;	/* record length in bytes of

				   * native record */
int sigfilecount = 1;		/* current signature being processed */
int eol;

/* subroutine calls */
int openfils ();		/* open the files to be used */
int get_func ();		/* parse the translation table line */
int put_keyword ();		/* output the keyword string */
int put_func ();		/* perform any functions requested */
int put_comments ();		/* output any comments after the functions */
int put_output ();		/* write the phoenix header and native

				 * signature out */

/* phxlate main program */
main (argc, argv)
     int argc;			/* number of arguments on command line * /*

				 * including program name */
     char *argv[];		/* command line arguments including program

				 * name */
{
  int result_open, result_get_func, j, result_read_orig, result_put_func;
  int buffer_len, result_put_keyword, result_put_comments;
  int result_read_translation, result_put_output;
  long lposition;
  int icount, ch;

  /* find out the byte orientation */
  union
    {
      int word;
      char bytes[4];
    }
  byteswap;

  byteswap.word = 1;

  /* if byte 0 is value 0, the bytes must be swapped */
  if (byteswap.bytes[0])
    {
      printf ("This machine is byte swapped!\n");
      swap_bytes = 1;
    }
  /* call the program to open the files */
  result_open = openfils (argc, argv);

  printf ("result_open = %d\n", result_open);
  if (result_open == 0)
    {
      printf ("files opened ok!\n");

      while (1)			/* do while there are signatures to be read */
	{

	  /* read the initial buffer full of data from the original file */
	  for (icount = 0; icount < native_hdr_length; icount++)
	    {
	      ch = getc (fptorig);
	      buff[icount] = ch;
	      if (ch == EOF)
		{
		  printf ("end of signature file processing\n");
		  exit (0);
		}
	    }
	  /* tell the user what signature is being processed */
	  printf ("Processing Signature %d\n", sigfilecount);

	  /* rewind the translation table file to its beginning */
	  printf ("rewindind file\n");
	  rewind (fptrxlate);

	  /* write the the phxlate calling sequence into the tmp file */
	  fprintf (fpttmp, "PhoenixHeaderCallingSequence=");
	  for (j = 0; j < argc; j++)
	    fprintf (fpttmp, "%s ", argv[j]);
	  fprintf (fpttmp, "\n");

	  /* call the program to read the translation table one call at a time */
	  while (1)
	    {
	      /* printf("calling get_func\n"); */

	      /* read a line from the translation table */
	      result_get_func = get_func ();

	      /* printf("result_get_func = %d\n",result_get_func); */

	      /* check for end of translation file - all done */
	      if (result_get_func == 6)
		{
		  printf ("writing to output\n");
		  result_put_output = put_output ();
		  if (result_put_output)
		    {
		      fprintf (stderr, "Problem with put_output\n");
		      exit (1);
		    }
		  break;
		}
	      /* output the keyword string */
	      result_put_keyword = put_keyword ();
	      if (result_put_keyword == 9)
		{
		  /* ignore the line of the translation table */
		}
	      else
		{
		  if (result_put_keyword)
		    {
		      fprintf (stderr, "Problem with put_keyword\n");
		      exit (1);
		    }
		  /* output the translated data */
		  result_put_func = put_func ();
		  if (result_put_func)
		    {
		      fprintf (stderr, "Problem with put_func\n");
		      exit (1);
		    }
		  /* output the comments string */
		  result_put_comments = put_comments ();
		  if (result_put_comments)
		    {
		      fprintf (stderr, "Problem with put_comments\n");
		      exit (1);
		    }
		}
	    }
	}
    }
  else
    fprintf (stderr, "problems opening the files!\n");
}
