/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_comm.c                                                */
/*/
   /* Created: 05 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_comments processes the keyword_string which is the       */
/* translation table line after the = sign.              */
/* The comments are terminated by a newline or an equals   */
/* modifiers are parsed from the comments string.             */
/*/
   /* Last Update: work in progress 6 Feb 1995 by fcb                       */
/* changed 9 May to add in equals terminator by fcb       */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

int
put_comments ()

{
  extern char comments[150];	/* remainder of keyword string */
  extern char func[10];		/* function string */
  extern FILE *fptrxlate, *fpttmp;
  extern int eol;
  int buffer_len;
  int i;

  /* check the comments string and send if it is not null */
  buffer_len = strlen (comments);

  /* printf("\ncomments buffer length =%d\n",buffer_len); */

  if (buffer_len != 0)
    {
      /* printf("%s",comments); */

      /* skip if 1st buffer char is equals) */
      /* this allows for multiple processes per line */
      if (comments[0] != '=')
	{

	  if (eol == 0)
	    fprintf (fpttmp, "%s", comments);
	  else
	    for (i = 0; i < buffer_len - 1; i++)
	      fprintf (fpttmp, "%c", comments[i]);


	  /* printf("put_comments =>%s<",comments); */
	}
    }
  else
    {
      /* send a newline character if there was function processing */
      buffer_len = strlen (func);
      if (buffer_len != 0 && eol == 0)
	{
	  /* printf("\n"); */
	  fprintf (fpttmp, "\n");
	}
    }

  return (0);
}
