/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_dbl.c                                                 */
/*/
   /* Created: 09 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_double processes each variable defined as 8 byte double */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

/* external subroutine */
int swap_n ();

int
put_double (write_double)
     double *write_double;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char buff[BUFFSIZ1];
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  char *write_buff;
  int results;
  extern int swap_bytes;	/* true if bytes must be swapped */
  union chardou
    {
      char chardbl[8];
      double dblchar;
    }
  unex;

  /* printf("\ndouble processing, st,end=%d,%d\n",data_address_start,
   * data_address_end); */

  results = 0;

  /* disregard the data address end for now */

  /* copy the characters from the buffer into the array */
  unex.chardbl[0] = buff[data_address_start - 1];
  unex.chardbl[1] = buff[data_address_start];
  unex.chardbl[2] = buff[data_address_start + 1];
  unex.chardbl[3] = buff[data_address_start + 2];
  unex.chardbl[4] = buff[data_address_start + 3];
  unex.chardbl[5] = buff[data_address_start + 4];
  unex.chardbl[6] = buff[data_address_start + 5];
  unex.chardbl[7] = buff[data_address_start + 6];

  /* swap the bytes if necessary */
  if (swap_bytes != 0)
    results = swap_n (unex.chardbl, 8);
  if (results)
    {
      fprintf (stderr, "problem with swap_n in put_dbl\n");
      return (1);
    }
  /* printf("put_double - %g\n",unex.dblchar); */

  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  unex.dblchar *= multiplier_value;
	  /* printf("put_double_mult 1 - %g\n",unex.dblchar); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  unex.dblchar += offset_value;
	  /* printf("put_float_offset 1 - %g\n",unex.dblchar); */
	}
    }
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  unex.dblchar *= multiplier_value;
	  /* printf("put_double_mult 2 - %g\n",unex.dblchar); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  unex.dblchar += offset_value;
	  /* printf("put_double_offset 2 - %g\n",unex.dblchar); */
	}
    }
  /* all done - leave */
  *write_double = unex.dblchar;
  return (0);
}
