/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_flt.c                                                 */
/*/
   /* Created: 23 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_float processes each variable defined as 4 byte real.    */
/*/
   /* Last Update: work in progress 24 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "fcntl.h"		/* needed for Oflags   */
#include "phxlate.h"

/* external subroutine */
int swap_n ();

int
put_float (write_float)
     float *write_float;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte */
  extern char buff[BUFFSIZ1];
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  int results;
  extern int swap_bytes;	/* true if bytes must be swapped */
  char *write_buff;
  double temp_double;		/* used for mod processing */
  union charflo
    {
      char charflt[4];
      float fltchar;
    }
  unex;

  /* printf("\nfloat processing %s, st,end=%d,%d\n",
   * data_address_start,data_address_end); */

  results = 0;

  /* disregard the data address end for now */

  /* printf("c1-4 =%2.2x %2.2x %2.2x %2.2x\n", buff[data_address_start-1],
   * buff[data_address_start], buff[data_address_start+1],
   * buff[data_address_start+2]); */

  /* copy the characters from the buffer into the array */
  unex.charflt[0] = buff[data_address_start - 1];
  unex.charflt[1] = buff[data_address_start];
  unex.charflt[2] = buff[data_address_start + 1];
  unex.charflt[3] = buff[data_address_start + 2];

  /* print the number before swapping */
  /* printf("put_float number is %g\n",unex.fltchar); */

  /* swap the bytes if necessary */
  if (swap_bytes != 0)
    results = swap_n (unex.charflt, 4);
  if (results)
    {
      fprintf (stderr, "problem with swap_n from put_flt\n");
      return (1);
    }
  /* printf("put_float - %g\n",unex.fltchar); */

  /* save the results in a temp double */
  temp_double = (double) unex.fltchar;

  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_float_mult 1 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_float_offset 1 - %g\n",temp_double); */
	}
    }
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_float_mult 2 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_float_offset 2 - %g\n",temp_double; */
	}
    }
  /* cast the double back to a float */
  *write_float = (float) temp_double;

  /* all done - leave */
  return (0);
}
