/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_func.c                                                */
/*/
   /* Created: 14 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_func processes each individual line from the trans-      */
/* lation table which has been parsed by get_func into the       */
/* following fields: keyword_string which is the trans-  */
/* lation table line up to and including the = sign, data        */
/* address start character position, data address stop   */
/* character position, function required to extract data,        */
/* mod1 and mod2 strings and finally the comments string.        */
/*/
   /* if no function string is present, the keyword_string is       */
/* not processed but is sent directly to the output file.        */
/* the following functions have been programmed and the  */
/* processing for each is shown in their individual      */
/* subroutines:                                          */
/*/
   /* 01)  ascii - extracts ascii character string to send out      */
/* 02)  ushort - extracts 2 byte unsigned short to send out      */
/* 03)  hex - extracts hex character string to send to output    */
/* 04)  float - extracts 4 byte real to send to output           */
/* 05)  enum - extracts 1 byte unsigned (0-255) to send out      */
/* 06)  bool0 - checks 1 char, if 0  true, else false    */
/* 07)  bool1 - checks 1 char, if 0 false, else true     */
/* 08)  booly - checks 1 char, if 0 yes, else no         */
/* 09)  booln - checks 1 char, if 0 no, else yes         */
/* 10)  long - extracts 4 byte long to send to output            */
/* 11)  num - extracts 1 byte char (-128 to 127) to send output  */
/* 12)  short - extracts 2 byte integer to send to output        */
/* 14)  vint4 - extracts 4 byte vax int*4 to send to output      */
/* 15)  vint2 - extracts 2 byte vax int*2 to send to output      */
/* 16)  ulong - extracts 4 byte unsigned long to send to output  */
/* 17)  double - extracts 8 byte double to send to output        */
/* 18)  swap_sh - extracts 2 byte swapped short to send out      */
/* 19)  swap_lg - extracts 4 byte swapped long to send out       */
/* 20)  swap_fl - extracts 4 byte swapped float to send out      */
/* 21)  total - extracts native signature length in ascii -      */
/* special                               */
/* 22)     i2 - extracts int from ascii string - outputs 2 digits        */
/*/
   / */
/* Last Update: work in progress 9 May 1995 by fcb                       */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

int put_ascii ();
int put_ushort ();
int put_hex ();
int put_float ();
int put_unum ();
int put_bool0 ();
int put_bool1 ();
int put_booly ();
int put_booln ();
int put_i2 ();
int put_long ();
int put_num ();
int put_short ();
int put_vreal ();
int put_vint4 ();
int put_vint2 ();
int put_ulong ();
int put_double ();
int put_swap_sh ();
int put_swap_lg ();
int put_swap_fl ();
int put_total ();

int
put_func ()

{
  extern char func[10];		/* function string */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern FILE *fptrxlate, *fpttmp;	/* file handles */
  extern long total_sig_length;
  extern int eol;
  int results;

  short temp_ushort;
  short temp_short;
  short temp_vint2;
  float temp_float;
  float temp_vreal;
  long temp_long;
  long temp_vint4;
  unsigned long temp_ulong;
  unsigned char temp_unum;
  char temp_num;
  char temp_buff[150];
  char temp_answer[10];
  double temp_double;

  if (strcmp ("total", func) == 0)
    {
      printf ("put_func called with func = >%s<\n", func);
    }
  /* if func string is null - all done - leave */
  if (strlen (func) == 0)
    return (0);

  /* initialize results to be ok */
  results = 0;

  /* test the func string for 'ascii' */
  if (strcmp ("ascii", func) == 0)
    {
      results = put_ascii (temp_buff);
      fprintf (fpttmp, "%s", temp_buff);
    }
  /* test the func string of 'hex' */
  else if (strcmp ("hex", func) == 0)
    {
      results = put_hex (temp_buff);
      fprintf (fpttmp, "%s", temp_buff);
    }
  /* test the func string for 'short' */
  else if (strcmp ("short", func) == 0)
    {
      results = put_short (&temp_short);
      fprintf (fpttmp, "%d", temp_short);
    }
  /* test the func string for 'swap_sh' */
  else if (strcmp ("swap_sh", func) == 0)
    {
      results = put_swap_sh (&temp_short);
      fprintf (fpttmp, "%d", temp_short);
    }
  /* test the func string for 'ushort' */
  else if (strcmp ("ushort", func) == 0)
    {
      results = put_ushort (&temp_ushort);
      fprintf (fpttmp, "%u", temp_ushort);
    }
  /* test the func string for 'float' */
  else if (strcmp ("float", func) == 0)
    {
      results = put_float (&temp_float);
      fprintf (fpttmp, "%g", temp_float);
    }
  /* test the func string for 'swap_fl' */
  else if (strcmp ("swap_fl", func) == 0)
    {
      results = put_swap_fl (&temp_float);
      fprintf (fpttmp, "%g", temp_float);
    }
  /* test the func string for 'unum' */
  else if (strcmp ("unum", func) == 0)
    {
      results = put_unum (&temp_unum);
      fprintf (fpttmp, "%u", temp_unum);
    }
  /* test the func string for 'num' */
  else if (strcmp ("num", func) == 0)
    {
      results = put_num (&temp_num);
      fprintf (fpttmp, "%d", temp_num);
    }
  /* test the func string for 'bool0' */
  else if (strcmp ("bool0", func) == 0)
    {
      results = put_bool0 (temp_answer);
      fprintf (fpttmp, "%s", temp_answer);
    }
  /* test the func string for 'bool1' */
  else if (strcmp ("bool1", func) == 0)
    {
      results = put_bool1 (temp_answer);
      fprintf (fpttmp, "%s", temp_answer);
    }
  /* test the func string for 'booly' */
  else if (strcmp ("booly", func) == 0)
    {
      results = put_booly (temp_answer);
      fprintf (fpttmp, "%s", temp_answer);
    }
  /* test the func string for 'booln' */
  else if (strcmp ("booln", func) == 0)
    {
      results = put_booln (temp_answer);
      fprintf (fpttmp, "%s", temp_answer);
    }
  /* test the func string for 'long' */
  else if (strcmp ("long", func) == 0)
    {
      results = put_long (&temp_long);
      fprintf (fpttmp, "%ld", temp_long);
    }
  /* test the func string for 'swap_lg' */
  else if (strcmp ("swap_lg", func) == 0)
    {
      results = put_swap_lg (&temp_long);
      fprintf (fpttmp, "%ld", temp_long);
    }
  /* test the func string for 'ulong' */
  else if (strcmp ("ulong", func) == 0)
    {
      results = put_ulong (&temp_ulong);
      fprintf (fpttmp, "%ld", temp_ulong);
    }
  /* test the func string for 'vreal' */
  else if (strcmp ("vreal", func) == 0)
    {
      results = put_vreal (&temp_vreal);
      fprintf (fpttmp, "%g", temp_vreal);
    }
  /* test the func string for 'vint4' */
  else if (strcmp ("vint4", func) == 0)
    {
      results = put_vint4 (&temp_vint4);
      fprintf (fpttmp, "%ld", temp_vint4);
    }
  /* test the func string for 'vint2' */
  else if (strcmp ("vint2", func) == 0)
    {
      results = put_vint2 (&temp_vint2);
      fprintf (fpttmp, "%d", temp_vint2);
    }
  /* test the func string for 'double' */
  else if (strcmp ("double", func) == 0)
    {
      results = put_double (&temp_double);
      fprintf (fpttmp, "%g", temp_double);
    }
  /* test the func string for 'total' */
  else if (strcmp ("total", func) == 0)
    {
      results = put_total (&temp_long);
      fprintf (fpttmp, "%ld", temp_long);
      printf ("Total Sig Length = %ld\n", temp_long);

      /* this is where the native record length is saved internally! */
      total_sig_length = temp_long;
    }
  /* test the func string for 'i2' */
  else if (strcmp ("i2", func) == 0)
    {
      results = put_i2 (&temp_long);
      fprintf (fpttmp, "%2.2ld", temp_long);
    }
  /* write error message if func is not defined above */
  else
    {
      printf ("unknown function >%s< in put_func!\n", func);
      return (1);
    }

  /* test for error from one of the put functions */
  if (results)
    {
      fprintf (stderr, "problem with one of the puts in put_func\n");
      return (1);
    }
  else
    return (0);
}
