/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_i2.c                                          */
/*/
   /* Created: 9 May 1995 by F. C. Betts - Veda Incorporated                */
/*/
   /* Purpose: put_i2 processes each string defined as an ascii             */
/* representation of a 2 digit number                        */
/*/
   /* Last Update: work in progress 9 May 1995 by fcb                       */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include <stdlib.h>		/* needed for atoi */
#include "phxlate.h"

int
put_i2 (write_long)
     long *write_long;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char buff[BUFFSIZ1];
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  int results;
  double temp_double;		/* used for mods */
  int buffer_len;
  char temp_buff[150];


  /* printf("\ni2 processing, st,end=%d,%d\n",data_address_start,
   * data_address_end); */

  /* set the write buffer to nulls */
  memset (temp_buff, '\0', 150);

  /* calculate the number of characters to transfer */
  buffer_len = (data_address_end - data_address_start) + 1;

  /* copy the ascii string into the write buffer */
  memcpy (temp_buff, &buff[data_address_start - 1], buffer_len);

  *write_long = atol (temp_buff);

  /* print the results to the display for debugging */
  /* printf("put_i2 string=>%s<, num=>%8.8ld<\n",temp_buff, write_long); */

  /* save the result as a double prior to math operations */
  temp_double = (double) *write_long;


  /* test for mod1 */
  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_long mult 1 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_long offset 1 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* test for mod2 */
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_long mult 2 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_long offset 2 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* cast the results to a long value */
  *write_long = (long) temp_double;


  /* all done - leave */
  return (0);
}
