/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_key.c                                                 */
/*/
   /* Created: 14 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_key processes the keyword_string which is the trans-     */
/* lation table line up to and including the = sign. If  */
/* no '=' character is found, the line is printed as is.         */
/*/
   /* Last Update: work in progress 6 Feb 1995 by fcb                       */
/* 24 Feb 1995 scan for ";" ignore line character which  */
/* allows Phoenix Translation Table lines to be  */
/* ignored - fcb                                         */
/* 9 May 1995 - skip output if single char only(=) - fcb  */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string processing */
#include "phxlate.h"

int
put_keyword ()
{
  /* first part of keyword= string */
  extern char keyword_string[150];
  extern FILE *fptrxlate, *fpttmp;	/* file pointers */

  /* printf("put_keyword =>%s<\n",keyword_string); */

  if (strlen (keyword_string) > 1)
    {
      /* scan for ";" */
      if (strchr (keyword_string, ';') == NULL)
	{
	  /* print the keyword string to the temp file */
	  fprintf (fpttmp, "%s", keyword_string);
	  return (0);
	}
      else
	{
	  /* printf("found ignore character\n");   */
	  return (9);
	}
    }
  return (0);
}
