/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_long.c                                                */
/*/
   /* Created: 19 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_long processes each variable defined as 4 byte long.     */
/*/
   /* Last Update: work in progress 1 Feb 1995 by fcb                       */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

/* external subroutine */
int swap_n ();

int
put_long (write_long)
     long *write_long;

{
  extern int data_address_start;	/* location of first byte        */
  extern int data_address_end;	/* location of last byte         */
  extern char buff[BUFFSIZ1];
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  int results;
  extern int swap_bytes;	/* true if bytes must be swapped */
  char *write_buff;
  double temp_double;		/* used for mods */
  union charlng
    {
      char chr_lng[4];
      long lng_chr;
    }
  unex;

  /* printf("\nlong processing st,end=%d,%d\n",
   * data_address_start,data_address_end); */

  /* initialize the results to be ok */
  results = 0;

  /* disregard the data address end for now */

  /* copy the buffer data into the characters */
  unex.chr_lng[0] = buff[data_address_start - 1];
  unex.chr_lng[1] = buff[data_address_start];
  unex.chr_lng[2] = buff[data_address_start + 1];
  unex.chr_lng[3] = buff[data_address_start + 2];

  /* swap the bytes if necessary */
  if (swap_bytes != 0)
    {
      /* printf("put_long calling swap_n with %ld\n", unex.lng_chr); */
      results = swap_n (unex.chr_lng, 4);
      /* printf("put_long recd %ld from swap_n\n", unex.lng_chr);   */
    }
  if (results)
    {
      fprintf (stderr, "problem with swap_n in put_long\n");
      return (1);
    }
  /* save the result as a double prior to math operations */
  temp_double = (double) unex.lng_chr;
  /* printf("unex.lng_chr = %ld, cast to temp_double =%g\n",
   * unex.lng_chr,temp_double); */

  /* printf("put_long - %ld double - %g mod1=>%s< mod2=>%s<\n",
   * unex.lng_chr,temp_double,mod1,mod2); */

  /* test for mod1 */
  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_long mult 1 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_long offset 1 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* test for mod2 */
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_long mult 2 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_long offset 2 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* cast the results to a long value */
  *write_long = (long) temp_double;

  /* unex.lng_chr = (long) temp_double; */
  /* printf("temp_double = %g cast *write_long = %ld, %ld\n",
   * temp_double,*write_long,unex.lng_chr); */

  /* all done - leave */
  return (0);
}
