/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_num.c                                                 */
/*/
   /* Created: 20 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_num processes each variable defined as char.             */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

int
put_num (write_num)
     char *write_num;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char buff[BUFFSIZ1];
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  double temp_double;

  /* printf("\nnum processing, st,end=%d,%d\n",data_address_start,
   * data_address_end); */

  /* disregard the data address end for now */
  /* save data in the new variable */
  *write_num = buff[data_address_start - 1];

  /* save the results as a double for mod processing */
  temp_double = (double) *write_num;

  /* test for mods */
  if (strlen (mod1) != 0)
    {

      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_num_mult 1 - %g\n", temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_num_offset 1 - %g\n", temp_double); */
	}
    }
  if (strlen (mod2) != 0)
    {

      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_num_mult 2 - %g\n", temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_num_offset 2 - %g\n", temp_double); */
	}
    }
  /* cast the result as a char value */
  *write_num = (char) temp_double;

  /* all done - leave */
  return (0);
}
