/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_out.c                                                 */
/*/
   /* Created: 13 Jan 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_output takes the translated phoenix header that was      */
/* written to tmp, prepends the totals line, writes out  */
/* the tmp file to the converted file, writes out the    */
/* trailer string, writes out the first buffer, reads and        */
/* writes the remainder of the native signature record to        */
/* the converted file and returns.                               */
/*/
   /* Last Update: work in progress 8 Feb 1995 by fcb                       */
/* changed to all stdio - 9 Feb 1995 - fcb                       */
/* changed to 1024 buffsiz1 - fcb                                */
/* changed version to 1.01 24 Feb 95 by fcb              */
/* changed version to 1.02 10 May 95 by fcb              */
/* changed version to 1.03 12 May 95 by fcb              */
/* changed Buffer to print only native_header            */
/* size 15 Aug 97 by rtb                                 */
/* added Phoenix Length, Filename, and Native            */
/* length fields after Phx Call seq              */
/* 20 Aug 97 by rtb                              */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

int
put_output ()

{
  /* file handles */
  extern FILE *fptorig, *fptrxlate, *fpttmp, *fptcnvt;	/* file handles */
  extern char buff[BUFFSIZ1];	/* read buffer */
  extern long total_sig_length;	/* length of a native record */
  extern long native_hdr_length;	/* length of a native header */
  extern int sigfilecount;	/* current signature being processed */
  extern char *fname;		/* output filename */

  long ltmp_length, ltmpcount;	/* length of tmp file &

				   * counter */
  long lnative_count;		/* counter for native record */
  int iresults, icount;
  int flag, lines;
  char ch;

  /* write the trailer  - 21 characters */
  fprintf (fpttmp, "[EndofPhoenixHeader]\n");

  /* find out what the file length is */
  ltmp_length = ftell (fpttmp);

  /* rewind tmp file which has the phoenix output */
  rewind (fpttmp);

  /* count lines in tmp file */
  lines = 0;
  for (ltmpcount = 0; ltmpcount < ltmp_length; ltmpcount++)
    {
      ch = getc (fpttmp);
      if (ch == '\n')
	lines++;
    }
  rewind (fpttmp);

  /* write the phoenix header version line - 71 is size of header */
  fprintf (fptcnvt, "\n[PhoenixHeaderVer01.03]\n");
  fprintf (fptcnvt, "PhoenixHeaderLength= %5.5ld\n", ltmp_length + 96);
  fprintf (fptcnvt, "PhoenixSigSize= %8.8ld\n",
	   ltmp_length + total_sig_length + 96);
  fprintf (fptcnvt, "PhoenixSigNum= %4.4d\n", sigfilecount);

  /* write out the phoenix header characters */
  flag = 0;
  for (ltmpcount = 0; ltmpcount < ltmp_length; ltmpcount++)
    {
      ch = getc (fpttmp);
      putc (ch, fptcnvt);
      if (ch == '\n' && flag == 0)
	{
	  flag = 1;
	  fprintf (fptcnvt, "PhoenixLines= %5.5d\n", lines + 8);
	  fprintf (fptcnvt, "native_header_length= %5.5d\n", native_hdr_length);
	  fprintf (fptcnvt, "Filename= %s\n", fname);
	}
    }

  /* rewind the tmp file which has the phoenix output */
  rewind (fpttmp);

  /* write out the first buffer */
  for (icount = 0; icount < native_hdr_length; icount++)
    putc (buff[icount], fptcnvt);

  /* while the results copied out is less than the native record length -
   * read and write */
  for (lnative_count = native_hdr_length; lnative_count < total_sig_length;
       lnative_count++)
    putc (getc (fptorig), fptcnvt);

  /* increment the signature count */
  sigfilecount++;

  return (0);
}
