/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_swlg.c                                                */
/*/
   /* Created: 11 Jan 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_swap_lg processes variable as a swapped 4 byte long      */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

/* external subroutine */
int swap_n ();

int
put_swap_lg (write_long)
     long *write_long;

{
  extern int data_address_start;	/* location of first byte        */
  extern int data_address_end;	/* location of last byte         */
  extern char buff[BUFFSIZ1];
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  int results;
  extern int swap_bytes;	/* true if bytes must be swapped */
  char *write_buff;
  double temp_double;

  union longflo
    {
      char charlong[4];
      long longchar;
    }
  unex;

  /* initialize results to ok */
  results = 0;

  /* printf("\nswap_lg processing %s, st,end=%d,%d\n",func
   * data_address_start,data_address_end); */

  /* disregard the data address end for now */

  /* save data in the write buffer */
  /* note that the data is swapped */
  unex.charlong[3] = buff[data_address_start - 1];
  unex.charlong[2] = buff[data_address_start];
  unex.charlong[1] = buff[data_address_start + 1];
  unex.charlong[0] = buff[data_address_start + 2];

  /* swap the bytes if necessary */
  if (swap_bytes != 0)
    results = swap_n (unex.charlong, 4);
  if (results)
    {
      fprintf (stderr, "problem with swap_n from put_swap_lg\n");
      return (1);
    }
  /* save result as a double before math operations */
  temp_double = (double) unex.longchar;

  /* printf("put_swap_lg - %d double - %g mod1=>%s< mod2=>%s<\n",
   * write_long,temp_double,mod1,mod2); */

  /* test for mod1 */
  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_swap_lg_mult 1 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_swap_lg_offset 1 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* test for mod2 */
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_swap_lg_mult 2 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_swap_lg_offset 2 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* cast the results to a long value */
  *write_long = (long) temp_double;

  /* all done - leave */
  return (0);
}
