/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_swsh.c                                                */
/*/
   /* Created: 11 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_swap_sh processes each variable as a swapped short.      */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

int
put_swap_sh (write_short)
     short *write_short;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char buff[BUFFSIZ1];
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  extern int swap_bytes;	/* true if bytes must be swapped */
  double temp_double;		/* used for mods */
  union charshrt
    {
      char charshort[2];
      short shortchar;
    }
  unex;

  /* printf("\nswap_sh processing st,end=%d,%d\n",data_address_start,
   * data_address_end); */

  /* disregard the data address end for now */

  /* convert it to integer */
  /* note that the bytes are swapped */
  if (swap_bytes != 0)
    {
      /* swap the bytes for this machine */
      /* tell user */
      /* printf("swapping bytes in put_swap_sh.c\n"); */
      unex.charshort[0] = buff[data_address_start - 1];
      unex.charshort[1] = buff[data_address_start];
      /* *write_short = ((buff[data_address_start-1] << 8) & 0xFF00) +
         * ((buff[data_address_start]) & 0x0FF); */
    }
  else
    {
      /* don't swap the order */
      /* printf(" not swapping bytes in put_swap_sh.c\n"); */
      unex.charshort[0] = buff[data_address_start];
      unex.charshort[1] = buff[data_address_start - 1];
      /* *write_short =  ((buff[data_address_start] << 8) & 0xFF00) +
         * ((buff[data_address_start-1]) & 0x0FF); */
    }

  /* save the results as a double prior to math operations */
  temp_double = (double) unex.shortchar;

  /* printf("put_short - %d double - %g mod1=>%s< mod2=>%s<\n",
   * write_short,temp_double,mod1,mod2); */

  /* test for mods */
  if (strlen (mod1) != 0)

    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_short_mult 1 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_short_offset 1 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  if (strlen (mod2) != 0)

    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_short_mult 2 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_short_offset 2 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* cast the results to a short value */
  *write_short = (short) temp_double;

  /* all done - leave */
  return (0);
}
