/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_totl.c                                                */
/*/
   /* Created: 13 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_total processes each string defined an ascii signature   */
/* length in bytes for the native data                   */
/*/
   /* Last Update: work in progress 24 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 and atol by fcb  */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include <stdlib.h>		/* needed for atoi */
#include "phxlate.h"

int
put_total (write_long)
     long *write_long;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char buff[BUFFSIZ1];
  int buffer_len;
  char temp_buff[150];


  printf ("\ntotl processing, st,end=%d,%d\n", data_address_start,
	  data_address_end);

  /* set the write buffer to nulls */
  memset (temp_buff, '\0', 150);

  /* calculate the number of characters to transfer */
  buffer_len = (data_address_end - data_address_start) + 1;

  /* copy the ascii string into the write buffer */
  memcpy (temp_buff, &buff[data_address_start - 1], buffer_len);

  *write_long = atol (temp_buff);

  /* print the results to the display for debugging */
  printf ("put_total string=>%s<, num=>%8.8ld<\n", temp_buff,
	  *write_long);

  /* all done - leave */
  return (0);
}
