/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_ulng.c                                                */
/*/
   /* Created: 03 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_ulng processes 4 byte unsigned long.                     */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include "phxlate.h"

/* external subroutine */
int swap_n ();

int
put_ulong (write_long)
     unsigned long *write_long;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char buff[BUFFSIZ1];
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  int results;
  extern int swap_bytes;	/* true if bytes must be swapped */
  char *write_buff;
  double temp_double;		/* used for mods */

  union charulong
    {
      char charulng[4];
      unsigned long ulngchar;
    }
  unex;

  /* printf("\nulong processing, st,end=%d,%d\n",data_address_start,
   * data_address_end); */

  /* initialize the results to ok */
  results = 0;

  /* disregard the data address end for now */

  /* save buffer data in the number array */
  unex.charulng[0] = buff[data_address_start - 1];
  unex.charulng[1] = buff[data_address_start];
  unex.charulng[2] = buff[data_address_start + 1];
  unex.charulng[3] = buff[data_address_start + 2];

  /* swap the bytes if necessary */
  if (swap_bytes != 0)
    results = swap_n (unex.charulng, 4);
  if (results)
    {
      fprintf (stderr, "problem with swap_n from put_ulng\n");
      return (1);
    }
  /* save the result as a double prior to math operations */
  temp_double = (double) unex.ulngchar;

  /* printf("put_long - %d double - %g mod1=>%s< mod2=>%s<\n",
   * write_long,temp_double,mod1,mod2); */

  /* test for mod1 */
  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_ulong mult 1 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_ulong offset 1 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* test for mod2 */
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_ulong mult 2 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_ulong offset 2 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* cast the results to a long value */
  *write_long = (long) temp_double;

  /* all done - leave */
  return (0);
}
