/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_unum.c                                                */
/*/
   /* Created: 16 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_unum processes each variable defined as char.    */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include "phxlate.h"

int
put_unum (write_unum)
     unsigned char *write_unum;
{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char buff[BUFFSIZ1];
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  double temp_double;

  /* printf("\nunum processing, st,end=%d,%d\n",data_address_start,
   * data_address_end); */

  /* disregard the data address end for now */
  /* save data in the new variable */
  *write_unum = buff[data_address_start - 1];

  /* save the results as a double for mod processing */
  temp_double = (double) *write_unum;

  /* test for mods */
  if (strlen (mod1) != 0)
    {

      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_unum_mult 1 - %g\n", temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_unum_offset 1 - %g\n", temp_double); */
	}
    }
  if (strlen (mod2) != 0)
    {

      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_unum_mult 2 - %g\n", temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_unum_offset 2 - %g\n", temp_double); */
	}
    }
  /* cast the result as a char value */
  *write_unum = (char) temp_double;

  /* all done - leave */
  return (0);
}
