/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_usht.c                                                */
/*/
   /* Created: 16 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_ushort processes each variable defined as ushort.        */
/*/
   /* Last Update: work in progress 1 Feb 1995 by fcb                       */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>
#include "phxlate.h"

int
put_ushort (write_ushort)
     unsigned short *write_ushort;

{
  extern int data_address_start;	/* location of first byte        */
  extern int data_address_end;	/* location of last byte         */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char buff[BUFFSIZ1];
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  extern int swap_bytes;	/* true if bytes must be swapped */
  double temp_double;		/* used for mods */
  union chrsht
    {
      char chrsht[2];
      short shtchr;
    }
  unex;

  /* printf("\nushort processing st,end=%d,%d\n",data_address_start,
   * data_address_end); */

  /* disregard the data address end for now */

  /* convert it to integer */
  if (swap_bytes != 0)
    /* swap the bytes for this machine */
    /* tell user */
    {
      /* printf("swapping bytes in put_ushort.c\n"); */
      unex.chrsht[0] = buff[data_address_start];
      unex.chrsht[1] = buff[data_address_start - 1];
      /* *write_ushort=((buff[data_address_start]<<8) & 0xFF00) +
         * ((buff[data_address_start-1]) & 0x0FF); */
    }
  else
    /* don't swap the order */
    {
      /* printf(" not swapping bytes in put_ushort.c\n"); */
      unex.chrsht[0] = buff[data_address_start - 1];
      unex.chrsht[1] = buff[data_address_start];
      /* *write_ushort =  ((buff[data_address_start-1] << 8) & 0xFF00) +
         * ((buff[data_address_start]) & 0x0FF); */
    }

  /* save the results as a double prior to math operations */
  temp_double = (double) unex.shtchr;

  /* printf("put_ushort - %d double - %g mod1=>%s< mod2=>%s<\n",
   * write_ushort,temp_double,mod1,mod2); */

  /* test for mods */
  if (strlen (mod1) != 0)

    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_short_mult 1 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_short_offset 1 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  if (strlen (mod2) != 0)

    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_short_mult 2 by %g = %g\n",
	     * multiplier_value,temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_short_offset 2 plus %g = %g\n",
	     * offset_value,temp_double); */
	}
    }
  /* cast the results to a short value */
  *write_ushort = (short) temp_double;

  /* all done - leave */
  return (0);
}
