/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_vaxr.c                                                */
/*/
   /* Created: 23 Dec 1994 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_vreal processes each variable as 4 byte vax real         */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

/* external subroutine */
int swap_n ();

int
put_vreal (write_vreal)
     float *write_vreal;
{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char buff[BUFFSIZ1];
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  int results;
  extern int swap_bytes;	/* true if bytes must be swapped */
  char *vaxc;
  double temp_double;

  union charflo
    {
      char charflt[4];
      float fltchar;
    }
  unex;

  /* printf("\nvreal processing %s, st,end=%d,%d\n",func,
   * data_address_start,data_address_end); */

  /* initialize results to ok */
  results = 0;

  /* disregard the data address end for now */

  /* save the data in the write buffer */
  /* notice that i am byte swapping and manipulating the second byte */
  unex.charflt[0] = buff[data_address_start] - 1;
  unex.charflt[1] = buff[data_address_start - 1];
  unex.charflt[2] = buff[data_address_start + 2];
  unex.charflt[3] = buff[data_address_start + 1];

  /* swap the bytes if necessary */
  if (swap_bytes != 0)
    results = swap_n (unex.charflt, 4);
  if (results)
    {
      fprintf (stderr, "problem with swap_n from put_vaxr\n");
      return (1);
    }
  /* printf("vax c1-4 =%x %x %x %x\n",vaxc[0],vaxc[1],vaxc[2], vaxc[3]); */

  /* save the results in a temp spot */
  temp_double = (double) unex.fltchar;

  /* check for mod strings */
  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_vreal_mult 1 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_vreal_offset 1 - %g\n",temp_double); */
	}
    }
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_vreal_vreal 2 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += (float) offset_value;
	  /* printf("put_vreal_offset 2 - %g\n",temp_double); */
	}
    }
  /* cast the results as float */
  *write_vreal = (float) temp_double;

  /* all done - leave */
  return (0);
}
