/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_vin2.c                                                */
/*/
   /* Created: 03 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_vint2 processes each variable defined as vax integer*2. */
/*/
   /* Last Update: work in progress 1 Feb 1995 by fcb                       */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

int
put_vint2 (write_short)
     short *write_short;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern char buff[BUFFSIZ1];
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  extern int swap_bytes;	/* true if bytes must be swapped */
  double temp_double;		/* used for mods */
  union charsht
    {
      char charshort[2];
      short shortchar;
    }
  unex;

  /* printf("\nvax int*2 processing, st,end=%d,%d\n",
   * data_address_start,data_address_end); */

  /* disregard the data address end for now */

  /* convert it to integer */
  /* note that I am byte swapping ***** */

  /* convert it to integer */
  if (swap_bytes != 0)
    /* swap the bytes for this machine */
    /* tell user */
    {
      /* printf("swapping bytes in put_vint2.c\n"); */
      unex.charshort[0] = buff[data_address_start - 1];
      unex.charshort[1] = buff[data_address_start];
      /* *write_short =  ((buff[data_address_start-1] << 8) & 0xFF00) +
         * ((buff[data_address_start]) & 0x0FF); */
    }
  else
    /* don't swap the order */
    {
      /* printf(" not swapping bytes in put_vint2.c\n"); */
      unex.charshort[0] = buff[data_address_start];
      unex.charshort[1] = buff[data_address_start - 1];
      /* *write_short =  ((buff[data_address_start] << 8) & 0xFF00) +
         * ((buff[data_address_start-1]) & 0x0FF); */
    }

  /* save the value in the temp buffer */
  temp_double = (double) unex.shortchar;

  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_vint2_mult 1 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_vint2_offset 1 - %g\n",temp_double); */
	}
    }
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_vint2_mult 2 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_vint2_offset 2 - %g\n",temp_double); */
	}
    }
  /* cast the results as a short */
  *write_short = (short) temp_double;

  /* return */
  return (0);

}
