/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Subroutine: put_vin4.c                                                */
/*/
   /* Created: 03 Jan 1995 by F. C. Betts - Veda Incorporated               */
/*/
   /* Purpose: put_vint4 processes each variable defined as vax integer*4   */
/*/
   /* Last Update: work in progress 31 Jan 1995 by fcb                      */
/* 23 Feb 1995 changed to 1024 BUFFSIZ1 by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

/* external subroutine */
int swap_n ();

int
put_vint4 (write_long)
     long *write_long;

{
  extern int data_address_start;	/* location of first byte of data */
  extern int data_address_end;	/* location of last byte of data */
  extern char mod1[10];		/* modifier 1 if present */
  extern char mod2[10];		/* modifier 2 if present */
  extern double multiplier_value;	/* mult mod value */
  extern double offset_value;	/* offset add value */
  extern char buff[BUFFSIZ1];
  int results;
  extern int swap_bytes;	/* true if bytes must be swapped */
  char *write_buff;
  double temp_double;		/* used for mod processing */

  union charlong
    {
      char charlong[4];
      long longchar;
    }
  unex;

  /* printf("\nvax int*4 processing, st,end=%d,%d\n",
   * data_address_start,data_address_end); */

  /* initialize results to ok */
  results = 0;

  /* disregard the data address end for now */

  /* convert it to a long integer */
  /* note that I am byte swapping ***** */
  unex.charlong[0] = buff[data_address_start + 2];
  unex.charlong[1] = buff[data_address_start + 1];
  unex.charlong[2] = buff[data_address_start];
  unex.charlong[3] = buff[data_address_start - 1];

  /* swap the bytes if necessary */
  if (swap_bytes != 0)
    results = swap_n (unex.charlong, 4);
  if (results)
    {
      fprintf (stderr, "problem with swap_n from put_vin4\n");
      return (1);
    }
  /* save the results in a double temp spot */
  temp_double = (double) unex.longchar;

  /* check for the mod strings */
  if (strlen (mod1) != 0)
    {
      if (strcmp ("mult", mod1) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_vint4_mult 1 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod1) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_vint4_offset 1 - %g\n",temp_double); */
	}
    }
  if (strlen (mod2) != 0)
    {
      if (strcmp ("mult", mod2) == 0)
	{
	  temp_double *= multiplier_value;
	  /* printf("put_vint4_mult 2 - %g\n",temp_double); */
	}
      if (strcmp ("offset", mod2) == 0)
	{
	  temp_double += offset_value;
	  /* printf("put_vint4_offset 2 - %g\n",temp_double); */
	}
    }
  /* cast the result as long */
  *write_long = (long) temp_double;

  /* all done - leave */
  return (0);
}
