/*****************************************************************************/
/*/
   /* THIS SOFTWARE AND AND ANY ACCOMPANYING DOCUMENTATION IS RELEASED "AS IS." */
/* THE U.S. GOVERNMENT MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,    */
/* CONCERNING THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION, INCLUDING,   */
/* WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A    */
/* PARTICULAR PURPOSE.  IN NO EVENT WILL THE U.S. GOVERNMENT BE LIABLE FOR   */
/* ANY DAMAGES, INCLUDING ANT LOST PROFITS, LOST SAVINGS OR OTHER            */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE, OR INABILITY  */
/* TO USE, THIS SOFTWARE OR ANY ACCOMPANYING DOCUMENTATION, EVEN IF          */
/* INFORMED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES."                  */
/*/
   /**************************************************************************** */
/************************************************************************/
/*/
   /* Program: readfils.c                                                 */
/*/
   /* Created: 27 Jan 1995 by F. C. Betts - Veda Incorporated             */
/*/
   /* Purpose: read_files strips the Phoenix Headers from files that      */
/* Phoenix Headers imbedded in them. Quick & Dirty           */
/*/
   /* Last Update: work in progress 27 Jan 1995 by fcb                    */
/* modified 10 Feb to handle stdio only by fcb           */
/*/
   /*********************************************************************** */
#include <stdio.h>		/* needed for standard i/o  */
#include <string.h>		/* needed for string functions */
#include "phxlate.h"

main (argc, argv)

     int argc;
     char *argv[];

{
  FILE *fpttmp;			/* Headers file handle  */
  FILE *phnxhandle;		/* PhoenixHeaded File handle */
  int j, temp_int, len_header, len_sig;
  char buffer1[29], LenBuffer[6], buffer2[16], SigBuffer[8];

  printf ("opening Phoenix Formatted file %s\n", argv[1]);
  if ((phnxhandle = fopen (argv[1], "rb")) == NULL)
    {
      fprintf (stderr, "Can't open file %s.\n", argv[j]);
      return (1);
    }
  printf ("phnxhandle = %d\n", phnxhandle);

  printf ("opening Headers.txt\n");
  if ((fpttmp = fopen ("Headers.txt", "w")) == NULL)
    {
      fprintf (stderr, "Can't open file Headers.txt\n");
      return (1);
    }
  printf ("fpttmp = %d\n", fpttmp);


  /* loop through the signature files */
  while (1)
    {
      /* clear the first buffer */
      memset (buffer1, '\0', 29);

      /* read the first 28 (0 thru 27) characters into the buffer and out to
         * the text */
      for (j = 0; j < 28; j++)
	{
	  temp_int = getc (phnxhandle);
	  /* printf("%c",temp_int); */
	  putc (temp_int, fpttmp);
	  *(buffer1 + j) = temp_int;
	}

      /* print the header string */
      printf ("buffer1 = >%s<\n", buffer1);

      /* clear the length  buffer */
      memset (LenBuffer, '\0', 6);

      /* read the next 5 (0 thru 4) characters into the length buffer */
      for (j = 0; j < 5; j++)
	{
	  temp_int = getc (phnxhandle);
	  /* printf("%c",temp_int); */
	  putc (temp_int, fpttmp);
	  *(LenBuffer + j) = temp_int;
	}

      /* print the Phoenix Header Length string */
      printf ("LenBuffer = >%s<\n", LenBuffer);

      /* convert the LenBuffer to an number */
      len_header = atoi (LenBuffer);
      if (len_header < 56)
	exit (0);

      /* print the converted string */
      printf ("len_header = %d\n", len_header);

      /* clear the second buffer */
      memset (buffer2, '\0', 16);

      /* read the next 15 (0 thru 14) characters into the second buffer */
      for (j = 0; j < 15; j++)
	{
	  temp_int = getc (phnxhandle);
	  putc (temp_int, fpttmp);
	  *(buffer2 + j) = temp_int;
	}

      /* print the buffer */
      printf ("buffer2 = >%s<\n", buffer2);

      /* clear the total sig size buffer */
      memset (SigBuffer, '\0', 8);

      /* read the next 7 (0 thru 6) characters into the sig size buffer */
      for (j = 0; j < 7; j++)
	{
	  temp_int = getc (phnxhandle);
	  putc (temp_int, fpttmp);
	  *(SigBuffer + j) = temp_int;
	}

      /* print the buffer */
      printf ("SigBuffer= >%s<\n", SigBuffer);

      /* convert the buffer to a number */
      len_sig = atoi (SigBuffer);

      /* print it */
      printf ("len_sig = %d\n", len_sig);

      /* read and write the rest of the Phoenix Header */
      for (j = 55; j < len_header; j++)
	{
	  temp_int = getc (phnxhandle);
	  putc (temp_int, fpttmp);
	}

      /* read the sig data and throw in on the floor! */
      for (j = len_header; j < len_sig; j++)
	temp_int = getc (phnxhandle);

      /* loop */
    }

  /* stop */

}
