/*****************************************************************************
 * This software and any accompanying documentation is released "as is."  The 
 * government makes no warranty of any kind, express or implied, 
 * concerning this software and any accompanying documentation, including, 
 * without limitation, any warranties of merchantability or fitness for a 
 * particular purpose.  In no event will the U.S. government be liable for any
 * damages, including any lost profits, lost savings or other incidental or 
 * consequential damages arising out of the use, or inability to use, this 
 * software or any accompanying documentation, even if informed in advance of 
 * the possibility of such damages.                
 /****************************************************************************/

/*****************************************************************************
 * Program Author:              David Hascher  - Veridian - Veda Operations
 * Creation Date:               4/1/98
 * Version:                             2.0
 * 
 * Program Description:  
 *       This is a testing program for the Phoenix Libraries.  It contains 
 *       examples of how the functions are used.
 *
 * Program Usage:
 *          driver
 *
 * Program Arguments:
 *       no arguments
 *
 * Revision History:
 *       4/1/98 - created - DEH
 ******************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include "phoenix.h"

extern hdr_parameters *phoenix_parameters;


main ()
{
  FILE *fd, *fd_out;
  int rc = 0, bytes_written = 0;
  short sht = 19;
  hdr_parameters *ptr;
  short temp_short;
  char *sig_ptr;
  unsigned long size;
  int max, i;
  char *arr[20];
  float *data;


  set_unbuffered_read ();
  set_buffered_write ();
  for (i = 0; i < 20; i++)
    arr[i] = (char *) malloc (40);

  fd = fopen ("hb03333.0000", "rb");
  read_sig (fd);

/*
  ptr = phoenix_parameters;
  while (ptr)
    {
      printf ("%s = %s\n", ptr->name, ptr->value);
      ptr = ptr->next;
    }

  max = get_header_names ("TarGet", arr, 20);
  printf ("max = %i\n", max);
  for (i = 0; i < max; i++)
    printf ("%s\n", arr[i]);

  rc = get_hdr_value ("profile", &temp_short, SHORT);

  rc = put_hdr_value ("profile", &sht, SHORT);
  rc = put_hdr_value ("dave", &sht, SHORT);
  rc = remove_hdr_parameter ("dave");
  rc = remove_hdr_parameter ("dave");
  rc = remove_hdr_parameter ("profile");

  ptr = phoenix_parameters;
  while (ptr)
    {
      printf ("%s = %s\n", ptr->name, ptr->value);
      ptr = ptr->next;
    }

  rc = get_hdr_value ("#profile", &temp_short, SHORT);

  sig_ptr = (char *) get_sig_addr ();
  size = get_sig_size ();
  printf ("\n\n%ld\n", size);

  size = get_phoenix_size ();
  printf ("\n\n%ld\n", size);

  sig_ptr = (char *) get_native_hdr_ptr ();

  data = (float *) get_data_ptr ();
*/

  fd_out = fopen ("test.output", "wb");
  rc = write_hdr (fd_out);
  size = get_sig_size () - get_phoenix_size ();
  rc = write_sig (fd_out, get_native_hdr_ptr (), size);
  fclose (fd_out);
}
