

/*****************************************************************************
 * This software and any accompanying documentation is released "as is."  The 
 * government makes no warranty of any kind, express or implied, 
 * concerning this software and any accompanying documentation, including, 
 * without limitation, any warranties of merchantability or fitness for a 
 * particular purpose.  In no event will the U.S. government be liable for any
 * damages, including any lost profits, lost savings or other incidental or 
 * consequential damages arising out of the use, or inability to use, this 
 * software or any accompanying documentation, even if informed in advance of 
 * the possibility of such damages.                
 /****************************************************************************/

/*****************************************************************************

 * Subroutines Included:  
 *       process_err
 *      iQuit
 *
 * Revision History:
 *       2/2/98 - process_err Created - DH
 *      2/2/98 - iQuit Created - DH
 ******************************************************************************/
#include <stdio.h>
#include "phoenix.h"


/**************************************************************************

 * process_err: Print out data to standard error on the specified error
 *
 * Parameters: s - string to identify the location of the error
 *             e - Error Type
 *
 **************************************************************************/
int
process_err (s, e)
     char *s;
     int e;
{
  fprintf (stderr, "%s: ", s);
  switch (e)
    {
    case FREAD_ERR:
      fprintf (stderr, "Read Error\n");
      break;
    case ALLOC_ER:
      fprintf (stderr, "Error allocating memory\n");
      break;
    case EOF_ER:
      fprintf (stderr, "File at EOF\n");
      break;
    case NO_NATIVE_HDR_LENGTH:
      fprintf (stderr, "Native header length not specified in header\n");
      break;
    case BUFFER_TO_BIG:
      fprintf (stderr, "Buffer length is greater than sige size\n");
      break;
    case NO_SIG_ERR:
      fprintf (stderr, "No signature to read\n");
      break;
    default:
      fprintf (stderr, "Unknown Error %d\n", e);
      break;
    }
  return 0;
}




/**************************************************************************

 * iQuit        This function does any required cleanup, and exits.  
 *              If a controlling process exists, it is informed of the
 *              error/quit condition.
 *
 * Parameters: num - exit code
 *
 **************************************************************************/

void
iQuit (num)
     int num;
{
  fflush (stdout);
  fflush (stderr);
  exit (num);
}
