/*****************************************************************************
* This software and any accompanying documentation is released "as is."  The 
* government makes no warranty of any kind, express or implied, 
* concerning this software and any accompanying documentation, including, 
* without limitation, any warranties of merchantability or fitness for a 
* particular purpose.  In no event will the U.S. government be liable for any
* damages, including any lost profits, lost savings or other incidental or 
* consequential damages arising out of the use, or inability to use, this 
* software or any accompanying documentation, even if informed in advance of 
* the possibility of such damages.                
/****************************************************************************/

/*****************************************************************************
* 
* Subroutines Included:  
*       main 
*
* Revision History:
*       2/2/28 - Created main - DH & RTB
******************************************************************************/
#include <stdio.h>
#include <fcntl.h>
#include "phoenix.h"

extern hdr_parameters *standard_parameters;


main(argc,argv)
int	argc;
char	*argv[];
{
    FILE		*fd, *fd_out;
    FILE		*coll;
    int			rc = 0, bytes_written = 0;
    hdr_parameters	*ptr;
    char		*cmd=(char *)malloc(150);
    char		*file;
    char		s1[MAX_STRING_LEN];
    char		value[1024];
    unsigned long	size;
    int			size2=0;

	set_unbuffered_read();
	set_unbuffered_write();

	if(argc < 2) exit(1);

	fd = fopen(argv[1], "rb");
	read_sig(fd);
	fclose(fd);

	size2 = get_phoenix_size();
	sprintf(cmd,"/home/contractor/rbadger/MD5/md5 -h %i %s | awk \'{print $NF}\'\n",size2,argv[1]);

	coll = popen(cmd,"r");
	rc = fread(s1,sizeof(char),MAX_STRING_LEN,coll);
	pclose(coll);
	if(rc==0) {
          fprintf(stderr,"MD5 program error\n");
          exit(1);
        }
	else s1[rc-1]='\0';

	strcpy(value,s1);
	rc = put_hdr_value("Chip_MD5_CheckSum", value, ASCII);

	fd_out = fopen(argv[2], "wb");
  	rc = write_hdr(fd_out);  
	size = get_sig_size() - get_phoenix_size();
	rc = write_sig(fd_out, get_native_hdr_ptr(), size);
	fclose(fd_out);
}
