/*****************************************************************************
 * This software and any accompanying documentation is released "as is."  The 
 * government makes no warranty of any kind, express or implied, 
 * concerning this software and any accompanying documentation, including, 
 * without limitation, any warranties of merchantability or fitness for a 
 * particular purpose.  In no event will the U.S. government be liable for any
 * damages, including any lost profits, lost savings or other incidental or 
 * consequential damages arising out of the use, or inability to use, this 
 * software or any accompanying documentation, even if informed in advance of 
 * the possibility of such damages.                
 /****************************************************************************/

/*****************************************************************************

 * Subroutines Included:  
 *       get_sig_addr
 *      get_sig_size
 *      get_data_ptr
 *      get_native_hdr_ptr
 *      get_phoenix_size
 *
 * Revision History:
 *       2/2/98 - Created get_sig_addr - DH
 *      2/2/98 - Created get_sig_size - DH
 *      2/2/98 - Created get_data_ptr - DH
 *      2/2/98 - Created get_native_hdr_ptr - DH
 *      2/2/98 - Created get_phoenix_size - DH
 ******************************************************************************/
#include "phoenix.h"
#include "private.h"


/**************************************************************************

 * get_sig_addr:  Return the starting address of the sig data
 *
 **************************************************************************/
void *
get_sig_addr ()
{
  return (void *) get_status (LOCATION);
}

/**************************************************************************

 * get_sig_size:  Return the length of the sig data
 *
 **************************************************************************/
unsigned long
get_sig_size ()
{
  return get_status (RECORD_SIZE);
}

/**************************************************************************

 * get_data_ptr:  get the starting address of the data in the signature
 *
 **************************************************************************/
void *
get_data_ptr ()
{
  return (void *) get_status (DATA_ADDR);
}

/**************************************************************************

 * get_native_hdr_ptr:  get the starting address of the native header
 *
 **************************************************************************/
void *
get_native_hdr_ptr ()
{
  return (void *) get_status (NATIVE_HDR_ADDR);
}

/**************************************************************************

 * get_phoenix_size:  get the length of the phoenix header
 *
 **************************************************************************/
unsigned long
get_phoenix_size ()
{
  return get_status (PHOENIX_SIZE);
}
