#define TRUE	1
#define FALSE 	0

#define BUFFER_LEN	200
#define TAPE_BLOCK_SIZE	8192

#define ALLOC_ER		20
#define EOF_ER			21
#define FREAD_ERR		22
#define FWRITE_ERR		23
#define SIG_ADDRESS_ERR		24
#define SIG_LENGTH_ERR		25
#define DATA_WRITE_ERR  	26
#define NO_NATIVE_HDR_LENGTH	27
#define BUFFER_TO_BIG		28
#define	NO_SIG_ERR		29

#define FLOAT	1
#define INT	2
#define DOUBLE	3
#define ASCII	4
#define SHORT	5

struct hdr_parameters_struct {
    char				*name;
    char				*value;
    struct hdr_parameters_struct	*next;
} ;

typedef struct hdr_parameters_struct hdr_parameters;


#define MAX_STRING_LEN		1024

union phoenix_type_union {
    float				float_value;
    int					int_value;
    double				double_value;
    char				string_value[MAX_STRING_LEN];
    short				short_value;
} ;

typedef union phoenix_type_union phoenix_type;


#define LOCATION		10
#define PHOENIX_SIZE		11
#define RECORD_SIZE		12
#define DATA_ADDR		13
#define NATIVE_HDR_ADDR		14
#define NATIVE_HDR_SIZE		15
#define BUFFERED_READ		16
#define BUFFERED_WRITE		17
#define BLOCK_LOADED		18
#define WRITE_DATA_START	19
#define DATA_BUFFERED		20

unsigned long get_data_size();
unsigned long get_hdr_size();

void *get_sig_addr();
unsigned long get_sig_size();
void *get_data_ptr();
void *get_native_hdr_ptr();
unsigned long get_phoenix_size();

int get_hdr_value();
int search_hdr_parameter();
int put_hdr_value();
int remove_hdr_parameter();
int fill_hdr_parameters();
static int buffered_read();
