
/*****************************************************************************
 * This software and any accompanying documentation is released "as is."  The 
 * government makes no warranty of any kind, express or implied, 
 * concerning this software and any accompanying documentation, including, 
 * without limitation, any warranties of merchantability or fitness for a 
 * particular purpose.  In no event will the U.S. government be liable for any
 * damages, including any lost profits, lost savings or other incidental or 
 * consequential damages arising out of the use, or inability to use, this 
 * software or any accompanying documentation, even if informed in advance of 
 * the possibility of such damages.                
 /****************************************************************************/

/*****************************************************************************

 * Subroutines Included:  
 *       set_buffered_read
 *      set_unbuffered_read
 *      set_buffered_write
 *      set_unbuffered_write
 *
 * Revision History:
 *       2/2/98 - Created set_buffered_read - DH
 *       2/2/98 - Created set_unbuffered_read - DH
 *       2/2/98 - Created set_buffered_write - DH
 *       2/2/98 - Created set_unbuffered_write - DH
 ******************************************************************************/
#include "phoenix.h"
#include "private.h"

/**************************************************************************

 * set_buffered_read: Turn on read buffer flag
 *
 **************************************************************************/
int
set_buffered_read ()
{
  set_status (BUFFERED_READ, TRUE);
}

/**************************************************************************

 * set_unbuffered_read: Turn off read buffer flag
 *
 **************************************************************************/
int
set_unbuffered_read ()
{
  set_status (BUFFERED_READ, FALSE);
}

/**************************************************************************

 * set_buffered_write: Turn on write buffer flag
 *
 **************************************************************************/
int
set_buffered_write ()
{
  set_status (BUFFERED_WRITE, TRUE);
}

/**************************************************************************

 * set_unbuffered_write: Turn off write buffer flag
 *
 **************************************************************************/
int
set_unbuffered_write ()
{
  set_status (BUFFERED_WRITE, FALSE);
}
