/*****************************************************************************
 * This software and any accompanying documentation is released "as is."  The 
 * government makes no warranty of any kind, express or implied, 
 * concerning this software and any accompanying documentation, including, 
 * without limitation, any warranties of merchantability or fitness for a 
 * particular purpose.  In no event will the U.S. government be liable for any
 * damages, including any lost profits, lost savings or other incidental or 
 * consequential damages arising out of the use, or inability to use, this 
 * software or any accompanying documentation, even if informed in advance of 
 * the possibility of such damages.                
 /****************************************************************************/

/*****************************************************************************

 * Subroutines Included:  
 *       get_status
 *      set_status
 *
 * Revision History:
 *       2/2/98 - Created get_status - DH
 *       2/2/98 - Created set_status - DH
 ******************************************************************************/
#include <stdio.h>
#include "phoenix.h"
#include "private.h"


typedef struct
  {
    void *location;
    unsigned long phoenix_size;
    void *data_addr;
    unsigned long record_size;
    void *native_hdr_addr;
    unsigned long native_hdr_size;
    short buffered_read;
    short buffered_write;
    short block_loaded;
    unsigned long write_data_start;
    short data_buffered;
  }
lib_status;


lib_status status;

/**************************************************************************

 * get_status: get the status or value of a flag
 *
 * Parameters: index - flag to check
 *
 * Return: Flag value
 *
 **************************************************************************/
unsigned long
get_status (index)
     int index;
{
  switch (index)
    {
    case LOCATION:
      return (unsigned long) status.location;
    case PHOENIX_SIZE:
      return status.phoenix_size;
    case RECORD_SIZE:
      return status.record_size;
    case DATA_ADDR:
      return (unsigned long) status.data_addr;
    case NATIVE_HDR_SIZE:
      return status.native_hdr_size;
    case NATIVE_HDR_ADDR:
      return (unsigned long) status.native_hdr_addr;
    case BUFFERED_READ:
      return status.buffered_read;
    case BUFFERED_WRITE:
      return status.buffered_write;
    case BLOCK_LOADED:
      return status.block_loaded;
    case WRITE_DATA_START:
      return status.write_data_start;
    case DATA_BUFFERED:
      return status.data_buffered;
    }
}

/**************************************************************************

 * set_status: set the status or value of a flag
 *
 * Parameters: index - flag to set
 *             value - value of flag to set
 *
 * Return: Flag value
 *
 **************************************************************************/
void
set_status (index, value)
     int index;
     unsigned long value;
{
  switch (index)
    {
    case LOCATION:
      status.location = (void *) value;
      break;
    case PHOENIX_SIZE:
      status.phoenix_size = value;
      break;
    case RECORD_SIZE:
      status.record_size = value;
      break;
    case DATA_ADDR:
      status.data_addr = (void *) value;
      break;
    case NATIVE_HDR_SIZE:
      status.native_hdr_size = value;
      break;
    case NATIVE_HDR_ADDR:
      status.native_hdr_addr = (void *) value;
      break;
    case BUFFERED_READ:
      status.buffered_read = (short) value;
      break;
    case BUFFERED_WRITE:
      status.buffered_write = (short) value;
      break;
    case BLOCK_LOADED:
      status.block_loaded = (short) value;
      break;
    case WRITE_DATA_START:
      status.write_data_start = value;
      break;
    case DATA_BUFFERED:
      status.data_buffered = (short) value;
      break;
    }
}
